/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.util;

import org.springframework.util.Assert;

public class Counter
implements Comparable<Counter> {
    private int value;

    public Counter() {
        this(0);
    }

    public Counter(int value) {
        this.value = value;
    }

    public synchronized int increment() {
        Assert.state((this.value < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Maximum counter value exceeded");
        return this.value++;
    }

    public synchronized int decrement() {
        Assert.state((this.value > Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Minimum counter value exceeded");
        return this.value--;
    }

    public synchronized int getValue() {
        return this.value;
    }

    @Override
    public synchronized int compareTo(Counter other) {
        return this.value > other.value ? 1 : (this.value < other.value ? -1 : 0);
    }
}

