/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections15.list.SetUniqueList;
import org.apache.commons.collections15.map.ListOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);
    public static final String COMMA = ",";
    public static final String EMPTY_STRING = "";

    public static final <T> void copyPropertiesIfNull(T dest, T orig) {
        try {
            Map description = PropertyUtils.describe(orig);
            for (String name : description.keySet()) {
                Helper.copyPropertyIfNull(dest, name, orig);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final void copyPropertyIfNull(Object dest, String name, Object orig) {
        try {
            Object oldValue = PropertyUtils.getProperty((Object)dest, (String)name);
            if (oldValue != null) {
                return;
            }
            Object newValue = PropertyUtils.getProperty((Object)orig, (String)name);
            logger.trace("name={} value={}", (Object)name, newValue);
            PropertyUtils.setProperty((Object)dest, (String)name, (Object)newValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final <T> T copyProperties(Class<T> c, Object orig) {
        try {
            T dest = c.newInstance();
            PropertyUtils.copyProperties(dest, (Object)orig);
            return dest;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final <T> Object getProperty(T bean, String property) {
        try {
            return PropertyUtils.getProperty(bean, (String)property);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final <T> String toCSV(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(COMMA);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static final <T> ListOrderedMap<String, String> describe(T element, String ... properties) {
        return Helper.describe(element, Arrays.asList(properties));
    }

    public static final <T> ListOrderedMap<String, String> describe(T element, List<String> properties) {
        try {
            Map map = BeanUtils.describe(element);
            ListOrderedMap orderedMap = new ListOrderedMap();
            for (String property : properties) {
                Object value = map.get(property);
                if (value == null) continue;
                orderedMap.put((Object)property, (Object)value.toString());
            }
            return orderedMap;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final <T> SetUniqueList<T> decorate() {
        return SetUniqueList.decorate(new ArrayList());
    }

    public static final String[] toArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    public static final <T> List<T> toEmptyList(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static final String toEmpty(String s) {
        if (Helper.isBlank(s)) {
            return EMPTY_STRING;
        }
        return s;
    }

    public static final String toEmpty(Object o) {
        if (o == null) {
            return EMPTY_STRING;
        }
        return Helper.toEmpty(o.toString());
    }

    public static final <T> void addAll(Collection<T> dest, Collection<T> orig) {
        if (!Helper.isEmpty(orig)) {
            dest.addAll(orig);
        }
    }

    public static final boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static final boolean isBlank(String s) {
        return s == null || s.trim().equals(EMPTY_STRING);
    }

    public static final List<String> splitAndTrimCSVToList(String csv) {
        if (Helper.isBlank(csv)) {
            return Collections.emptyList();
        }
        String[] tokens = csv.split(COMMA);
        ArrayList<String> list = new ArrayList<String>();
        for (String token : tokens) {
            list.add(token.trim());
        }
        return list;
    }
}

