/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.validate;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.kuali.maven.plugins.graph.validate.NodeValidator;
import org.springframework.util.Assert;

public abstract class DependencyNodeValidator
implements NodeValidator<MavenContext> {
    TreeHelper helper = new TreeHelper();
    State state;

    public DependencyNodeValidator(State state) {
        this.state = state;
    }

    protected abstract void validateState(List<DependencyNode> var1);

    @Override
    public void validate(Node<MavenContext> node) {
        List<Node<MavenContext>> list = node.getBreadthFirstList();
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>();
        for (Node<MavenContext> element : list) {
            DependencyNode dn = element.getObject().getDependencyNode();
            Assert.state((dn.getArtifact() != null ? 1 : 0) != 0, (String)"Artifact for a dependency node can't be null");
            State elementState = State.getState(dn.getState());
            if (this.state != elementState) continue;
            nodes.add(dn);
        }
        this.validateState(nodes);
    }

    public State getState() {
        return this.state;
    }
}

