/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.validate;

import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.kuali.maven.plugins.graph.validate.DependencyNodeValidator;
import org.springframework.util.Assert;

public class IncludedDependencyNodeValidator
extends DependencyNodeValidator {
    public IncludedDependencyNodeValidator() {
        super(State.INCLUDED);
    }

    @Override
    protected void validateState(List<DependencyNode> nodes) {
        HashMap<String, Artifact> ids = new HashMap<String, Artifact>();
        HashMap<String, Artifact> partialIds = new HashMap<String, Artifact>();
        for (DependencyNode node : nodes) {
            Artifact a = node.getArtifact();
            Assert.state((node.getRelatedArtifact() == null ? 1 : 0) != 0, (String)"Included nodes can't contain related artifacts");
            String id = TreeHelper.getArtifactId(a);
            String partialId = TreeHelper.getPartialArtifactId(a);
            ids.put(id, a);
            partialIds.put(partialId, a);
        }
        int c1 = nodes.size();
        int c2 = ids.size();
        int c3 = partialIds.size();
        boolean valid = c1 == c2 && c2 == c3;
        Assert.state((boolean)valid, (String)("Unique included artifact id counts don't match.  c1=" + c1 + " c2=" + c2 + " c3=" + c3));
    }
}

