/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugin.ksite.mojo;

import java.util.List;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.common.SiteContext;
import org.kuali.maven.common.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KualiSiteMojo
extends AbstractMojo
implements SiteContext {
    UrlBuilder builder = new UrlBuilder();
    private boolean latest;
    private String latestToken;
    private String downloadSnapshotPath;
    private String downloadReleasePath;
    private String downloadExternalPath;
    private String publishBase;
    private String publicBase;
    private String downloadBase;
    private String organizationGroupId;
    private String snapshotSnippet;
    private MavenProject project;
    private List<String> orgPomGavs;

    public List<MavenProject> getOrgPoms() {
        return this.builder.getMavenProjects(this.orgPomGavs);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String publicUrl = this.builder.getPublicUrl(this.getProject(), (SiteContext)this);
        String downloadUrl = this.builder.getDownloadUrl(this.getProject(), (SiteContext)this);
        String publishUrl = this.builder.getPublishUrl(this.getProject(), (SiteContext)this);
        MavenProject project = this.getProject();
        DistributionManagement dm = project.getDistributionManagement();
        Site site = dm.getSite();
        this.handlePublicUrl(publicUrl, project);
        this.handlePublishUrl(publishUrl, site);
        this.handleDownloadUrl(downloadUrl, dm);
    }

    protected void warn(String pomString, String calculatedString, String propertyDescription) {
        this.getLog().warn((CharSequence)"****************************************");
        this.getLog().warn((CharSequence)(propertyDescription + " mismatch"));
        this.getLog().warn((CharSequence)("  Supplied Value: " + pomString));
        this.getLog().warn((CharSequence)("Calculated value: " + calculatedString));
        this.getLog().warn((CharSequence)"****************************************");
    }

    protected void handleDownloadUrl(String downloadUrl, DistributionManagement dm) {
        if (this.builder.isUnresolved(dm.getDownloadUrl())) {
            this.getLog().info((CharSequence)("Setting download url to " + downloadUrl));
            dm.setDownloadUrl(downloadUrl);
            return;
        }
        if (!this.builder.isUrlMatch(downloadUrl, dm.getDownloadUrl())) {
            this.warn(dm.getDownloadUrl(), downloadUrl, "Download url");
        }
        this.getLog().info((CharSequence)("Using download url from the POM " + dm.getDownloadUrl()));
    }

    protected void handlePublishUrl(String publishUrl, Site site) {
        if (this.builder.isUnresolved(site.getUrl())) {
            this.getLog().info((CharSequence)("Setting site publication url to " + publishUrl));
            site.setUrl(publishUrl);
            return;
        }
        if (!this.builder.isUrlMatch(publishUrl, site.getUrl())) {
            this.warn(site.getUrl(), publishUrl, "Site publication url");
        }
        this.getLog().info((CharSequence)("Using site publication url - " + site.getUrl()));
    }

    protected void handlePublicUrl(String publicUrl, MavenProject project) {
        if (this.builder.isUnresolved(project.getUrl())) {
            this.getLog().info((CharSequence)("Setting public url to " + publicUrl));
            project.setUrl(publicUrl);
            return;
        }
        if (!this.builder.determineMatch(publicUrl, project.getUrl(), (SiteContext)this, project)) {
            this.warn(project.getUrl(), publicUrl, "Public url");
            this.getLog().info((CharSequence)("Using public url from the POM " + project.getUrl()));
        } else {
            project.setUrl(publicUrl);
            this.getLog().info((CharSequence)("Using public url " + project.getUrl()));
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getOrganizationGroupId() {
        return this.organizationGroupId;
    }

    public void setOrganizationGroupId(String parentGroupId) {
        this.organizationGroupId = parentGroupId;
    }

    public String getDownloadSnapshotPath() {
        return this.downloadSnapshotPath;
    }

    public void setDownloadSnapshotPath(String downloadSnapshotPath) {
        this.downloadSnapshotPath = downloadSnapshotPath;
    }

    public String getDownloadReleasePath() {
        return this.downloadReleasePath;
    }

    public void setDownloadReleasePath(String downloadReleasePath) {
        this.downloadReleasePath = downloadReleasePath;
    }

    public String getDownloadExternalPath() {
        return this.downloadExternalPath;
    }

    public void setDownloadExternalPath(String downloadExternalPath) {
        this.downloadExternalPath = downloadExternalPath;
    }

    public String getDownloadBase() {
        return this.downloadBase;
    }

    public void setDownloadBase(String downloadBase) {
        this.downloadBase = downloadBase;
    }

    public List<String> getOrgPomGavs() {
        return this.orgPomGavs;
    }

    public void setOrgPomGavs(List<String> orgPomGavs) {
        this.orgPomGavs = orgPomGavs;
    }

    public String getSnapshotSnippet() {
        return this.snapshotSnippet;
    }

    public void setSnapshotSnippet(String snapshotSnippet) {
        this.snapshotSnippet = snapshotSnippet;
    }

    public String getPublishBase() {
        return this.publishBase;
    }

    public void setPublishBase(String publishBase) {
        this.publishBase = publishBase;
    }

    public String getPublicBase() {
        return this.publicBase;
    }

    public void setPublicBase(String publicBase) {
        this.publicBase = publicBase;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    public String getLatestToken() {
        return this.latestToken;
    }

    public void setLatestToken(String latestToken) {
        this.latestToken = latestToken;
    }
}

