/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.PropertyUtils;
import org.kuali.maven.plugins.properties.OutputStyle;

public abstract class AbstractWritePropertiesMojo
extends AbstractMojo {
    MavenProject project;
    File outputFile;
    OutputStyle outputStyle;
    String prefix;
    String encoding;
    String comment;

    protected void writeProperties(File file, Properties properties, OutputStyle outputStyle, String prefix, String encoding, String comment) {
        Properties prefixed = PropertyUtils.getPrefixedProperties((Properties)properties, (String)prefix);
        Properties formatted = this.getFormattedProperties(prefixed, outputStyle);
        PropertyUtils.store((Properties)formatted, (File)file, (String)encoding, (String)comment);
    }

    protected Properties getFormattedProperties(Properties properties, OutputStyle style) {
        switch (style) {
            case NORMAL: {
                return properties;
            }
            case ENVIRONMENT_VARIABLE: {
                return PropertyUtils.reformatKeysAsEnvVars((Properties)properties);
            }
        }
        throw new IllegalArgumentException((Object)((Object)this.outputStyle) + " is unknown");
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public OutputStyle getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

