/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.EncUtils;
import org.kuali.common.util.PropertyUtils;

public class DecryptAllPropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private String endsWith;
    private String password;

    public void execute() throws MojoExecutionException {
        TextEncryptor encryptor = EncUtils.getTextEncryptor((String)this.password);
        Properties props = PropertyUtils.getGlobalProperties((Properties)this.project.getProperties());
        List keys = PropertyUtils.getEndsWithKeys((Properties)props, (String)this.endsWith);
        for (String key : keys) {
            String value = props.getProperty(key);
            String decryptedValue = this.getDecryptedValue(encryptor, value);
            int length = this.endsWith.length();
            String newKey = key.substring(0, key.length() - length);
            this.project.getProperties().setProperty(newKey, decryptedValue);
        }
    }

    protected String getDecryptedValue(TextEncryptor encryptor, String value) {
        if (PropertyUtils.isEncryptedPropertyValue((String)value)) {
            return PropertyUtils.decryptPropertyValue((TextEncryptor)encryptor, (String)value);
        }
        return encryptor.decrypt(value);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getEndsWith() {
        return this.endsWith;
    }

    public void setEndsWith(String endsWith) {
        this.endsWith = endsWith;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

