/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.EncUtils;
import org.kuali.common.util.PropertyUtils;

public class EncryptPropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private String[] properties;
    private String password;

    public void execute() throws MojoExecutionException {
        TextEncryptor encryptor = EncUtils.getTextEncryptor((String)this.password);
        Properties p = PropertyUtils.getGlobalProperties((Properties)this.project.getProperties());
        List<String> includes = PropertyUtils.getSortedKeys((Properties)this.project.getProperties());
        if (this.properties != null) {
            includes = Arrays.asList(this.properties);
        }
        PropertyUtils.trim((Properties)p, includes, null);
        PropertyUtils.encrypt((Properties)p, (TextEncryptor)encryptor);
        this.project.getProperties().putAll((Map<?, ?>)p);
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public MavenProject getProject() {
        return this.project;
    }
}

