/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class GetGAVProperty
extends AbstractMojo {
    private MavenProject project;
    private String groupId;
    private String artifactId;
    private String version;
    private String property;
    private String defaultValue;
    private String suffix;

    public void execute() throws MojoExecutionException {
        List<String> keys = this.getKeys();
        String value = this.getValue(this.project, keys);
        if (StringUtils.isBlank((String)value)) {
            this.getLog().info((CharSequence)("No value for '" + this.property + "'"));
        } else {
            String key = this.property + "." + this.suffix;
            this.getLog().info((CharSequence)("Setting " + key + "=" + value));
            this.project.getProperties().setProperty(key, value);
        }
    }

    protected String getValue(MavenProject project, List<String> keys) {
        for (String key : keys) {
            String value = this.getProperty(key);
            this.getLog().debug((CharSequence)(key + "=" + value));
            if (StringUtils.isBlank((String)value)) continue;
            return value;
        }
        return this.defaultValue;
    }

    protected List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(this.property + "." + this.groupId + "." + this.artifactId + "." + this.version);
        keys.add(this.property + "." + this.groupId + "." + this.artifactId);
        keys.add(this.property + "." + this.groupId);
        keys.add(this.property);
        return keys;
    }

    protected String getProperty(String key) {
        String sys = System.getProperty(key);
        String proj = this.project.getProperties().getProperty(key);
        if (!StringUtils.isBlank((String)sys)) {
            return sys;
        }
        return proj;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

