/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.plugins.properties.Version;

public class ParseVersionPropertiesMojo
extends AbstractMojo {
    public static final String MAVEN_SNAPSHOT_TOKEN = "SNAPSHOT";
    private MavenProject project;
    private String[] properties;
    private boolean silent;

    public void execute() throws MojoExecutionException {
        Properties props = this.project.getProperties();
        for (String key : this.properties) {
            String value = this.getProperty(key);
            if (StringUtils.isBlank((String)value)) continue;
            Version version = this.parseVersion(value);
            this.setProjectProperty(key, "major", version.getMajor(), props);
            this.setProjectProperty(key, "minor", version.getMinor(), props);
            this.setProjectProperty(key, "incremental", version.getIncremental(), props);
            this.setProjectProperty(key, "qualifier", version.getQualifier(), props);
            this.setProjectProperty(key, "trimmed", this.trimSnapshot(value), props);
        }
    }

    protected String trimSnapshot(String version) {
        if (version.toUpperCase().endsWith("-SNAPSHOT")) {
            int length = MAVEN_SNAPSHOT_TOKEN.length() + 1;
            return StringUtils.left((String)version, (int)(version.length() - length));
        }
        return version;
    }

    protected void setProjectProperty(String key, String suffix, String value, Properties props) {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        props.setProperty(key + "." + suffix, value);
        if (!this.silent) {
            this.getLog().info((CharSequence)("Setting " + key + "." + suffix + "=" + value));
        }
    }

    protected Version parseVersion(String s) {
        boolean snapshot = s.toUpperCase().endsWith("-SNAPSHOT");
        Version version = new Version();
        version.setSnapshot(snapshot);
        String[] tokens = StringUtils.split((String)s, (String)".-");
        if (tokens.length > 0) {
            version.setMajor(tokens[0]);
        }
        if (tokens.length > 1) {
            version.setMinor(tokens[1]);
        }
        if (tokens.length > 2) {
            version.setIncremental(tokens[2]);
        }
        String qualifier = this.getQualifier(tokens);
        version.setQualifier(qualifier);
        return version;
    }

    protected String getQualifier(String[] tokens) {
        if (tokens.length <= 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 3; i < tokens.length && !tokens[i].toUpperCase().equals(MAVEN_SNAPSHOT_TOKEN); ++i) {
            if (i != 3) {
                sb.append("-");
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    protected String getProperty(String key) {
        String sys = System.getProperty(key);
        String proj = this.project.getProperties().getProperty(key);
        if (!StringUtils.isBlank((String)sys)) {
            return sys;
        }
        return proj;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

