/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.common.util.CollectionUtils;
import org.kuali.maven.common.PropertiesUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class ReadPropertiesMojo
extends AbstractMojo {
    PropertiesUtils utils = new PropertiesUtils();
    private MavenProject project;
    private String[] locations;
    private boolean quiet;
    private boolean silent;
    private boolean verbose;
    private String ignore;

    public void execute() throws MojoExecutionException {
        List<String> ignoreList = this.getIgnoreList();
        this.updateProjectProperties(ignoreList);
        Properties allProperties = this.utils.getMavenProperties(this.project);
        this.resolveValues(this.project.getProperties(), allProperties);
    }

    protected void resolveValues(Properties p1, Properties p2) {
        for (String name : p1.stringPropertyNames()) {
            String originalValue = p1.getProperty(name);
            String resolvedValue = this.utils.getResolvedValue(originalValue, p2);
            p1.setProperty(name, resolvedValue);
        }
    }

    protected void updateProperties(Properties p1, Properties p2, List<String> ignore) {
        Set<String> names = p2.stringPropertyNames();
        for (String name : names) {
            if (ignore.contains(name)) continue;
            String value = p2.getProperty(name);
            p1.setProperty(name, value);
        }
    }

    protected String toEmpty(String s) {
        if (StringUtils.isBlank((String)s)) {
            return "";
        }
        return s;
    }

    protected boolean exists(String location) {
        if (StringUtils.isBlank((String)location)) {
            return false;
        }
        File file = new File(location);
        if (file.exists()) {
            return true;
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        return resource.exists();
    }

    protected boolean validate(String location) throws MojoExecutionException {
        boolean exists = this.exists(location);
        if (exists) {
            return true;
        }
        if (this.quiet) {
            if (this.verbose && !this.silent) {
                this.getLog().info((CharSequence)("Ignoring non-existent properties file '" + this.toEmpty(location) + "'"));
            }
            return false;
        }
        throw new MojoExecutionException("Non-existent properties file '" + location + "'");
    }

    protected InputStream getInputStream(String location) throws IOException {
        File file = new File(location);
        if (file.exists()) {
            return new FileInputStream(location);
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        return resource.getInputStream();
    }

    protected Properties getProperties(String location) throws MojoExecutionException {
        Properties properties;
        InputStream in = null;
        try {
            Properties properties2 = new Properties();
            in = this.getInputStream(location);
            if (location.toLowerCase().endsWith(".xml")) {
                properties2.loadFromXML(in);
            } else {
                properties2.load(in);
            }
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error reading properties file " + location, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignoreProperties) {
        this.ignore = ignoreProperties;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    protected List<String> getIgnoreList() {
        List ignoreList = CollectionUtils.getTrimmedListFromCSV((String)this.ignore);
        if (!this.silent && this.verbose && !StringUtils.isBlank((String)this.ignore)) {
            this.getLog().info((CharSequence)("Ignoring " + this.ignore));
        }
        return ignoreList;
    }

    protected void updateProjectProperties(List<String> ignoreList) throws MojoExecutionException {
        Properties projectProperties = this.project.getProperties();
        for (int i = 0; i < this.locations.length; ++i) {
            Properties allProperties = this.utils.getMavenProperties(this.project);
            String originalLocation = this.locations[i];
            String resolvedLocation = this.utils.getResolvedValue(originalLocation, allProperties);
            this.getLog().debug((CharSequence)("o=" + originalLocation + " r=" + resolvedLocation));
            if (!this.validate(resolvedLocation)) continue;
            if (!this.silent) {
                this.getLog().info((CharSequence)("Loading " + resolvedLocation));
            }
            Properties p = this.getProperties(resolvedLocation);
            this.updateProperties(projectProperties, p, ignoreList);
        }
    }
}

