/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class TranslatePropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private String[] properties;
    private String suffix;

    protected String getProperty(String key) {
        String sys = System.getProperty(key);
        String proj = this.project.getProperties().getProperty(key);
        if (!StringUtils.isBlank((String)sys)) {
            return sys;
        }
        return proj;
    }

    public void execute() throws MojoExecutionException {
        Properties props = this.project.getProperties();
        for (String key : this.properties) {
            String value = this.getProperty(key);
            if (StringUtils.isBlank((String)value)) continue;
            String newValue = value.replace(".", "/");
            String newKey = key + this.suffix;
            this.getLog().info((CharSequence)("Setting " + newKey + "=" + newValue));
            props.setProperty(newKey, newValue);
        }
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void setProperties(String[] properties) {
        this.properties = properties;
    }
}

