/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.properties;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.maven.plugins.properties.AbstractWritePropertiesMojo;
import org.kuali.maven.plugins.properties.MavenUtils;

public class WriteProjectProperties
extends AbstractWritePropertiesMojo {
    private boolean includeSystemProperties;
    private boolean includeEnvironmentVariables;
    private String exclude;
    private String include;
    private List<String> includes;
    private List<String> excludes;
    private boolean resolvePlaceholders;
    private boolean includeStandardMavenProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.project.getProperties());
        if (this.includeStandardMavenProperties) {
            properties.putAll((Map<?, ?>)MavenUtils.getInternalMavenProperties(this.project));
        }
        if (this.includeEnvironmentVariables) {
            properties.putAll((Map<?, ?>)PropertyUtils.getEnvAsProperties());
        }
        if (this.includeSystemProperties) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        List includeList = CollectionUtils.sortedMerge(this.includes, (String)this.include);
        List excludeList = CollectionUtils.sortedMerge(this.excludes, (String)this.exclude);
        this.override(properties, includeList);
        if (this.resolvePlaceholders) {
            Properties resolved = PropertyUtils.getResolvedProperties((Properties)properties);
            this.getLog().info((CharSequence)("Resolved " + resolved.size() + " properties"));
            properties.putAll((Map<?, ?>)resolved);
        }
        PropertyUtils.trim((Properties)properties, (List)includeList, (List)excludeList);
        this.writeProperties(this.outputFile, properties, this.outputStyle, this.prefix, this.encoding, this.comment);
    }

    protected void override(Properties properties, List<String> includes) {
        List keys = PropertyUtils.getSortedKeys((Properties)properties, includes, null);
        Properties global = PropertyUtils.getGlobalProperties((Properties)properties);
        properties.clear();
        for (String key : keys) {
            String value = global.getProperty(key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
    }

    public boolean isIncludeSystemProperties() {
        return this.includeSystemProperties;
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public boolean isIncludeEnvironmentVariables() {
        return this.includeEnvironmentVariables;
    }

    public void setIncludeEnvironmentVariables(boolean includeEnvironmentVariables) {
        this.includeEnvironmentVariables = includeEnvironmentVariables;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isResolvePlaceholders() {
        return this.resolvePlaceholders;
    }

    public void setResolvePlaceholders(boolean resolvePlaceholders) {
        this.resolvePlaceholders = resolvePlaceholders;
    }

    public boolean isIncludeStandardMavenProperties() {
        return this.includeStandardMavenProperties;
    }

    public void setIncludeStandardMavenProperties(boolean includeStandardMavenProperties) {
        this.includeStandardMavenProperties = includeStandardMavenProperties;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }
}

