/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.spring;

import java.lang.reflect.InvocationTargetException;
import org.kuali.common.util.execute.Executable;
import org.kuali.maven.plugins.spring.AbstractSpringMojo;
import org.kuali.maven.plugins.spring.SpringMojoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MethodInvoker;

@Component
public class MojoExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(MojoExecutable.class);
    MethodInvoker invoker = new MethodInvoker();
    String serviceMethod = "mojoCallback";
    AbstractSpringMojo mojo;
    SpringMojoService service;

    public void execute() {
        Object[] args = new Object[]{this.service.getClass().getName(), this.serviceMethod, ((Object)((Object)this.mojo)).getClass().getSimpleName()};
        logger.debug("Invoking  - [{}.{}({})]", args);
        this.invoker.setTargetObject((Object)this.service);
        this.invoker.setTargetMethod(this.serviceMethod);
        this.invoker.setArguments(new Object[]{this.mojo});
        this.invoke(this.invoker);
        logger.debug("Completed - [{}.{}({})]", args);
    }

    protected void invoke(MethodInvoker invoker) {
        try {
            invoker.prepare();
            invoker.invoke();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public MethodInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(MethodInvoker invoker) {
        this.invoker = invoker;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public AbstractSpringMojo getMojo() {
        return this.mojo;
    }

    public void setMojo(AbstractSpringMojo mojo) {
        this.mojo = mojo;
    }

    public SpringMojoService getService() {
        return this.service;
    }

    public void setService(SpringMojoService service) {
        this.service = service;
    }
}

