/*-
 * #%L
 * %%
 * Copyright (C) 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.research.gg.fetcher.fetch.search

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.core.JsonGenerator
import com.fasterxml.jackson.core.JsonParser
import com.fasterxml.jackson.databind.DeserializationContext
import com.fasterxml.jackson.databind.JsonDeserializer
import com.fasterxml.jackson.databind.JsonSerializer
import com.fasterxml.jackson.databind.SerializerProvider
import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import java.io.IOException
import java.util.*
import org.kuali.research.gg.fetcher.fetch.FetchConstants.DEFAULT_DATE_FORMAT
import org.kuali.research.gg.fetcher.fetch.Results

data class SearchParams(
    val resultType: String? = null,
    val formSet: String?,
    val formStatus: String? = null
)

data class SearchResults(
    val searchParams: SearchParams?,
    val families: List<Family> = emptyList(),
    override val accessKey: String?,
    override val errorMsgs: List<String> = emptyList()
) : Results

data class Family(val id: String?, val name: String?, val shortName: String?, val forms: List<Form> = emptyList())
data class Form(
    val id: String,
    val name: String,
    val agency: String?,
    val description: String?,
    val version: String,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val lastUpdateDate: Date?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val expirationDate: Date?,
    val ombNumber: String?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val fillable: Boolean?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val retiredDate: Date?,
    val inProgressStatus: String?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val targetProdDate: Date?,
    val contourFormID: String?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val pdfExpirationDate: Date?,
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DEFAULT_DATE_FORMAT)
    val oiraExpirationDate: Date?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val existsPDF: Boolean?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val existsSchema: Boolean?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val existsDataAnalysis: Boolean?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val existsInstructions: Boolean?,
    @JsonSerialize(using = YNBooleanSerializer::class)
    @JsonDeserialize(using = YNBooleanDeserializer::class)
    val active: Boolean?
)

private class YNBooleanSerializer : JsonSerializer<Boolean>() {

    @Throws(IOException::class)
    override fun serialize(bool: Boolean?, generator: JsonGenerator, provider: SerializerProvider) {
        when {
            bool == null -> generator.writeNull()
            bool -> generator.writeString(YES)
            else -> generator.writeString(NO)
        }
    }
}

class YNBooleanDeserializer : JsonDeserializer<Boolean>() {

    @Throws(IOException::class)
    override fun deserialize(parser: JsonParser, context: DeserializationContext): Boolean? {
        return when {
            NO == parser.text -> false
            YES == parser.text -> true
            else -> null
        }
    }
}

private const val YES: String = "Y"
private const val NO: String = "N"
