<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" 
xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" 
xmlns:SBIR_STTR_Information_1_2="http://apply.grants.gov/forms/SBIR_STTR_Information_1_2-V1.2" xmlns:header="http://apply.grants.gov/system/Header-V1.0"
xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" >

	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:header="http://apply.grants.gov/system/Header-V1.0" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">

			<fo:layout-master-set>
				<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
					<fo:region-body margin-top="0.2in" margin-bottom="0.4in"/>
					<fo:region-after extent="0.3in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="default-page" format="1" initial-page-number="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:table width="100%"
                  space-before.optimum="0pt"
                  space-after.optimum="0pt"
                  table-layout="fixed">
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-body>
                     <fo:table-row>
                        <fo:table-cell hyphenate="true" language="en"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="left"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block>
                              <fo:inline font-size="8px">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                              </fo:inline>
                           </fo:block>
                        </fo:table-cell>
                        <fo:table-cell hyphenate="true" language="en" line-height="10pt"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="right"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block><fo:inline font-size="8px">Funding Opportunity Number: <xsl:value-of select="/*/*/header:OpportunityID"/></fo:inline>
                                     <fo:inline font-size="8px">.       Received Date: <xsl:value-of select="/*/*/footer:ReceivedDateTime"/></fo:inline></fo:block>
                        </fo:table-cell>
                     </fo:table-row>
                  </fo:table-body>
               </fo:table>
            </fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<!--Data components-->
					<!--Block below is for the field named ProgramTypeRadioRequiredField with FieldID -->
					<fo:block-container position="absolute" left="4.848484848484849px" top="23.636363636363637px" height="12px" width="130.3030303030303px">
						<fo:block font-size="9px" font-family="arialuni"/>
					</fo:block-container>
					<!--Block below is for the field named SBIRSTTRTypeRadioRequiredField with FieldID -->
					<fo:block-container position="absolute" left="4.848484848484849px" top="73.33333333333334px" height="12px" width="139.3939393939394px">
						<fo:block font-size="9px" font-family="arialuni"/>
					</fo:block-container>
					
					
     <!-- NEW FORMAT BELOW ======================================================================================================================================= -->               
	 <!--  Note changed the above line to avoid the  org.xml.sax.SAXParseException that was being thrown -->
					<fo:block-container position="absolute" left="0.2in" top="1.0in" height="9in" width="7.9in" border="solid 1pt black">
						<fo:block />
					</fo:block-container>

					<fo:block-container position="absolute" left="0.3in" top="0.6in" height="15px">
						<fo:block text-align="center" font-size="12px" font-family="arialuni" font-weight="bold">SBIR/STTR Information</fo:block>
					</fo:block-container>

 					<fo:block-container position="absolute" left="0.3in" top="0.5in" height="15px">
						<fo:block text-align="right" font-size="6px" font-family="arialuni">OMB Number: 4040-0001</fo:block>
                        <fo:block text-align="right" font-size="6px" font-family="arialuni">Expiration date: 10/31/2019</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="0.3in" top="1.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni" font-weight="bold">Agency to which you are applying (select only one)*</fo:block>
					</fo:block-container>  

                    <fo:block-container position="absolute" left="0.3in" top="1.4in" height="12px">
                        <fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:Agency"/>
										<xsl:with-param name="schemaChoice">DOE</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.45in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">DOE</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="1.05in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:Agency"/>
										<xsl:with-param name="schemaChoice">HHS</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="1.20in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">HHS</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="1.75in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:Agency"/>
										<xsl:with-param name="schemaChoice">USDA</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="1.9in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">USDA</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="2.45in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:Agency"/>
										<xsl:with-param name="schemaChoice">Other</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="2.6in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Other:</fo:block>
					</fo:block-container>
					
   					<fo:block-container position="absolute" left="3.05in" top="1.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:OtherAgency)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:OtherAgency"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					
					
					<fo:block-container position="absolute" left="0.3in" top="1.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">SBC Control ID:*</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="2.25in" top="1.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBCControlID)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBCControlID"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
 
 
					<fo:block-container position="absolute" left="0.3in" top="1.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni" font-weight="bold">Program Type (select only one)*</fo:block>
					</fo:block-container>  

                    <fo:block-container position="absolute" left="0.3in" top="2.1in" height="12px">
                        <fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ProgramType"/>
										<xsl:with-param name="schemaChoice">SBIR</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.45in" top="2.1in" height="12px"> 
						<fo:block font-size="9px" font-family="arialuni">SBIR</fo:block>
					</fo:block-container> 

 
					<fo:block-container position="absolute" left="1.25in" top="2.1in" height="12px"> 
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ProgramType"/>
										<xsl:with-param name="schemaChoice">STTR</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="1.5in" top="2.1in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">STTR</fo:block>
					</fo:block-container>


					<fo:block-container position="absolute" left="0.3in" top="2.3in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ProgramType"/>
										<xsl:with-param name="schemaChoice">Both</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
				 </fo:block-container>
					<fo:block-container position="absolute" left="0.45in" top="2.3in" height="12px" width="7.0in">
						<fo:block font-size="9px" font-family="arialuni">Both&#160; 
                      	<fo:inline font-size="8px" font-family="arialuni">(See agency-specific instructions to determine whether a particular agency allows a single submission for both SBIR and STTR)</fo:inline>
                        </fo:block>                        
					</fo:block-container>   
                    
                    
					<fo:block-container position="absolute" left="0.3in" top="2.6in" height="12px">
						<fo:block font-size="9px" font-family="arialuni" font-weight="bold">Application Type (select only one)*</fo:block>
					</fo:block-container>               
                    

					<fo:block-container position="absolute" left="0.3in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Phase I</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.45in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Phase I</fo:block>
					</fo:block-container>
                    
                    
					<fo:block-container position="absolute" left="1.25in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Phase II</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="1.4in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Phase II</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="2.2in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Fast-Track</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="2.35in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Fast-Track</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="3.15in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Direct Phase II</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="3.3in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Direct Phase II</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="4.4in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Phase IIA</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="4.55in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Phase IIA</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="5.35in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice">Phase IIB</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="5.5in" top="2.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Phase IIB</fo:block>
					</fo:block-container>
                    

					<fo:block-container position="absolute" left="0.3in" top="3.0in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:ApplicationType"/>
										<xsl:with-param name="schemaChoice"></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.45in" top="3.0in" height="12px" width="7.0in">
						<fo:block font-size="9px" font-family="arialuni">Commercialization Readiness Program
						<fo:inline font-size="8px" font-family="arialuni">(See agency-specific instructions to determine application type participation.)</fo:inline>
                        </fo:block>
					</fo:block-container>  

					<fo:block-container position="absolute" left="0.3in" top="3.3in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Phase I Letter of Intent Number:</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="2.25in" top="3.3in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:PhaseILetterofIntentNumber)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:PhaseILetterofIntentNumber"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>

					<fo:block-container position="absolute" left="0.3in" top="3.6in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">* Agency Topic/Subtopic:</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="2.25in" top="3.6in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:AgencyTopicSubtopic)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:AgencyTopicSubtopic"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>

                    
                    <fo:block-container position="absolute" left="0.2in" top="3.9in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>     
                    
           			<fo:block-container position="absolute" left="0.3in" top="4.0in" height="15px">
						<fo:block font-size="10px" font-family="arialuni" font-weight="bold">Questions 1-7 must be completed by all SBIR and STTR Applicants:</fo:block>
					</fo:block-container>         
   
   					<fo:block-container position="absolute" left="0.3in" top="4.2in" height="36px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">1a. Do you certify that at the time of award your organization will meet the eligibility criteria for a small business as defined in the funding opportunity announcement?* </fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="7.0in" top="4.2in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SmallBusinessEligibility"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.15in" top="4.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block> 
 					</fo:block-container>

					<fo:block-container position="absolute" left="7.6in" top="4.2in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SmallBusinessEligibility"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.75in" top="4.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
   					</fo:block-container>
 
					<fo:block-container position="absolute" left="0.3in" top="4.6in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">1b. Anticipated Number of personnel to be employed at your organization at the time of award.*</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="7.0in" top="4.6in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:NumberOfEmployees)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:NumberOfEmployees"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					
					<fo:block-container position="absolute" left="0.3in" top="4.8in" height="36px"  width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">1c. Is your small business majority owned by venture capital operating companies, hedge funds, or private equity firms?*</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="7.0in" top="4.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:VCOC"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.15in" top="4.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block> 
 					</fo:block-container>

					<fo:block-container position="absolute" left="7.6in" top="4.8in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:VCOC"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.75in" top="4.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
   					</fo:block-container>
					
					<fo:block-container position="absolute" left="0.3in" top="5.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">1d. Is your small business a Faculty or Student-Owned entity?*</fo:block>
					</fo:block-container>
   					<fo:block-container position="absolute" left="7.0in" top="5.2in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:FacultyStudentOwned"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.15in" top="5.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block> 
 					</fo:block-container>
					
					<fo:block-container position="absolute" left="7.6in" top="5.2in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:FacultyStudentOwned"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.75in" top="5.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
   					</fo:block-container>
 
                    <fo:block-container position="absolute" left="0.2in" top="5.4in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>       
	
   					<fo:block-container position="absolute" left="0.3in" top="5.5in" height="24px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">2. Does this application include subcontracts with Federal laboratories or any other Federal Government agencies?*</fo:block>
					</fo:block-container>

   					<fo:block-container position="absolute" left="7.0in" top="5.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SubcontractsIncluded"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
 					<fo:block-container position="absolute" left="7.15in" top="5.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
   					</fo:block-container>
                      
					<fo:block-container position="absolute" left="7.6in" top="5.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SubcontractsIncluded"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.75in" top="5.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
   					</fo:block-container>   
                    
   					<fo:block-container position="absolute" left="0.3in" top="5.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">If yes, insert the names of the Federal laboratories/agencies:*</fo:block>
					</fo:block-container>   
   					<fo:block-container position="absolute" left="0.3in" top="5.9in" height="60px" width="7.85in">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SubcontractorNames) or //SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SubcontractorNames = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SubcontractorNames"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
 
                    
                    <fo:block-container position="absolute" left="0.2in" top="6.4in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container> 
				
                    <fo:block-container position="absolute" left="0.3in" top="6.5in" height="24px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">3. Are you located in a HUBZone? To find out if your business is in a HUBZone, use the mapping utility provided by the Small Business Administration at its web site: http://www.sba.gov *</fo:block>
					</fo:block-container>  
					<fo:block-container position="absolute" left="7.0in" top="6.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:LocatedInHUBZone"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>                  
                    <fo:block-container position="absolute" left="7.15in" top="6.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.6in" top="6.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:LocatedInHUBZone"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
 					</fo:block-container>	
					<fo:block-container position="absolute" left="7.75in" top="6.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container>               
 
                    
                    <fo:block-container position="absolute" left="0.2in" top="6.8in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
                   
                    <fo:block-container position="absolute" left="0.3in" top="6.9in" height="12px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">4. Will all research and development on the project be performed in its entirety in the United States?*</fo:block>
					</fo:block-container>                    
                    <fo:block-container position="absolute" left="7.0in" top="6.9in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DomesticPerformance"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
 					<fo:block-container position="absolute" left="7.15in" top="6.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="7.6in" top="6.9in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DomesticPerformance"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container  position="absolute" left="7.75in" top="6.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container> 
                    
                   
					<fo:block-container position="absolute" left="0.3in" top="7.1in" height="12px" width="3in">
						<fo:block font-size="9px" font-family="arialuni">If no, provide an explanation in an attached file.</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="3.7in" top="7.1in" height="12px" width="1.0in">
						<fo:block font-size="9px" font-family="arialuni">Explanation:*</fo:block>
					</fo:block-container> 
                    <fo:block-container position="absolute" left="5.0in" top="7.1in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:NonDomesticPerformanceExplanation/att:FileName) or //SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:NonDomesticPerformanceExplanation/att:FileName = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:NonDomesticPerformanceExplanation/att:FileName"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    
                    <fo:block-container position="absolute" left="0.2in" top="7.3in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
                    

 					<fo:block-container position="absolute" left="0.3in" top="7.4in" height="36px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">5. Has the applicant and/or Program Director/Principal Investigator submitted proposals for essentially equivalent work under other Federal program solicitations or received other Federal awards for essentially equivalent work?*</fo:block>
					</fo:block-container>                   
                    
  					<fo:block-container position="absolute" left="7.0in" top="7.4in" height="12px" >
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:EquivalentProposalsSubmitted"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.15in" top="7.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container> 					
                    
                    <fo:block-container position="absolute" left="7.6in" top="7.4in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:EquivalentProposalsSubmitted"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>                  
					<fo:block-container position="absolute" left="7.75in" top="7.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container> 
                    
                    <fo:block-container position="absolute" left="0.3in" top="7.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">If yes, insert the names of the other Federal agencies:*</fo:block>
					</fo:block-container>
                    
                    <fo:block-container position="absolute" left="0.3in" top="7.9in" height="36px" width="7.85in">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:EquivalentProposalRecipients) or //SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:EquivalentProposalRecipients = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:EquivalentProposalRecipients"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
 
                    
                    <fo:block-container position="absolute" left="0.2in" top="8.4in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>

					<fo:block-container position="absolute" left="0.3in" top="8.5in" height="36px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">6. Disclosure Permission Statement: If this application does not result in an award, is the Government permitted to disclose the title of
								your proposed project, and the name, address, telephone number and email address of the official signing for the applicant organization to state-level economic development organizations that may be interested in contacting you for further information (e.g., possible collaborations, investment)?*</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.0in" top="8.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DisclosurePermission"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
							<fo:block-container position="absolute" left="7.15in" top="8.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>
                    
					<fo:block-container position="absolute" left="7.6in" top="8.5in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DisclosurePermission"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
				 <fo:block-container position="absolute" left="7.75in" top="8.5in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container>
 
                    
                    <fo:block-container position="absolute" left="0.2in" top="9.2in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
                                                          
					<fo:block-container position="absolute" left="0.3in" top="9.3in" height="36px" width="7.5in">
						<fo:block font-size="9px" font-family="arialuni">7.Commercialization Plan: The following applications require a Commercialization Plan: Phase I (DOE only), Phase II (all agencies), Phase I/II Fast-Track (all agencies). Include a Commercialization Plan in accordance with the agency announcement and/or agency-specific instructions.*</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="0.3in" top="9.8in" height="12px" width="1.0in">
						<fo:block font-size="9px" font-family="arialuni">Attach File:*</fo:block>
					</fo:block-container>					
                    <fo:block-container position="absolute" left="1.5in" top="9.8in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:CommercializationPlan/att:FileName) or //SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:CommercializationPlan/att:FileName = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:CommercializationPlan/att:FileName"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
				</fo:flow>
			</fo:page-sequence>
		

        
        	<fo:page-sequence master-reference="default-page" format="1" initial-page-number="2">
            <fo:static-content flow-name="xsl-region-after">
               <fo:table width="100%"
                  space-before.optimum="0pt"
                  space-after.optimum="0pt"
                  table-layout="fixed">
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-column column-width="proportional-column-width(1)"/>
                  <fo:table-body>
                     <fo:table-row>
                        <fo:table-cell hyphenate="true" language="en"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="left"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block>
                              <fo:inline font-size="8px">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                              </fo:inline>
                           </fo:block>
                        </fo:table-cell>
                        <fo:table-cell hyphenate="true" language="en" line-height="10pt"
                         padding-start="0pt"
                         padding-end="0pt"
                         padding-before="1pt"
                         padding-after="1pt"
                         display-align="before"
                         text-align="right"
                         border-style="solid"
                         border-width="0pt"
                         border-color="white">
                           <fo:block><fo:inline font-size="8px">Funding Opportunity Number: <xsl:value-of select="/*/*/header:OpportunityID"/></fo:inline>
                                     <fo:inline font-size="8px">.       Received Date: <xsl:value-of select="/*/*/footer:ReceivedDateTime"/></fo:inline></fo:block>
                        </fo:table-cell>
                     </fo:table-row>
                  </fo:table-body>
               </fo:table>
            </fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block-container position="absolute" left="0.2in" top="1.0in" height="9in" width="7.9in" border="solid 1pt black">
						<fo:block />
					</fo:block-container>

					<fo:block-container position="absolute" left="0.3in" top="0.6in" height="15px">
						<fo:block text-align="center" font-size="12px" font-family="arialuni" font-weight="bold">SBIR/STTR Information</fo:block>
					</fo:block-container>

 					<fo:block-container position="absolute" left="0.3in" top="0.5in" height="15px">
						<fo:block text-align="right" font-size="6px" font-family="arialuni">OMB Number: 4040-0001</fo:block>
                        <fo:block text-align="right" font-size="6px" font-family="arialuni">Expiration date: 10/31/2019</fo:block>
					</fo:block-container>

 
 
					<fo:block-container position="absolute" left="0.3in" top="1.2in" height="12px">
						<fo:block font-size="9px" font-family="arialuni" font-weight="bold">SBIR-Specific Questions:</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="0.3in" top="1.5in" height="24px" width="7.5in">
						<fo:block font-size="9px" font-style="italic" font-family="arialuni" font-weight="bold">Questions 8 and 9 apply only to SBIR applications.  If you are submitting <fo:inline font-style="underline">ONLY</fo:inline> an STTR application, leave questions 8 and 9 blank and proceed to question 10.</fo:block>
					</fo:block-container>
					
                    <fo:block-container position="absolute" left="0.3in" top="1.9in" height="24px" width="6.5in">
                    	<fo:block font-size="9px" font-family="arialuni">8. Have you received SBIR Phase II awards from the Federal Government?  If yes, provide a company commercialization history in accordance with agency-specific instructions using this attachment.*</fo:block>
					</fo:block-container>
     				
                    <fo:block-container position="absolute" left="7.0in" top="1.9in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_PhaseIIAwardsReceived"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.15in" top="1.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="7.6in" top="1.9in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_PhaseIIAwardsReceived"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
                 	</fo:block-container>       
					<fo:block-container position="absolute" left="7.75in" top="1.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container> 
     
					<fo:block-container position="absolute" left="0.3in" top="2.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Attach File:*</fo:block>
					</fo:block-container>     
         
    			<fo:block-container position="absolute" left="1.5in" top="2.4in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_CommercializationHistory/att:FileName) or //SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_CommercializationHistory/att:FileName = ''">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_CommercializationHistory/att:FileName"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>	
     
     
					<fo:block-container position="absolute" left="0.3in" top="2.7in" height="36px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">9. Will the Project Director/Principal Investigator have his/her primary employment with the small business at the time of award?*</fo:block>
					</fo:block-container> 
                    
                    <fo:block-container position="absolute" left="7.0in" top="2.7in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:SBIR_PDPIPrimarilyEmployed"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                   <fo:block-container position="absolute" left="7.15in" top="2.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container> 
 
					<fo:block-container position="absolute" left="7.6in" top="2.7in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2SBIR_PDPIPrimarilyEmployed"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
					<fo:block-container position="absolute" left="7.75in" top="2.7in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container>
  
 
                    
                    <fo:block-container position="absolute" left="0.2in" top="3.25in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
                    
 
 
					<fo:block-container position="absolute" left="0.3in" top="3.4in" height="15px">
						<fo:block font-size="10px" font-style="normal" font-family="arialuni" font-weight="bold">STTR-Specific Questions:</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="0.3in" top="3.6in" height="24px" width="7.5in">
						<fo:block font-size="9px" font-style="italic" font-family="arialuni" font-weight="bold">Questions 10 - 12 apply only to STTR applications.  If you are submitting <fo:inline font-style="underline">ONLY</fo:inline> an SBIR application, leave questions 10 - 12 blank.</fo:block>
					</fo:block-container>
                     
 					<fo:block-container position="absolute" left="0.3in" top="4.0in" height="12px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">10. Please indicate whether the answer to BOTH of the following questions is TRUE:*</fo:block>
					</fo:block-container>
 					<fo:block-container position="absolute" left="0.3in" top="4.2in" height="24px" width="7.5in">
						<fo:block font-size="9px" font-family="arialuni">(1) Does the Project Director/Principal Investigator have a formal appointment or commitment either with the small business directly (as an employee or a contractor) OR as an employee of the Research Institution, which in turn has made a commitment to the small business through the STTR application process; AND</fo:block>
					</fo:block-container>

                    <fo:block-container position="absolute" left="0.3in" top="4.7in" height="24px" width="7.5in">
						<fo:block font-size="9px" font-family="arialuni">(2) Will the Project Director/Principal Investigator devote at least 10% effort to the proposed project?</fo:block>
					</fo:block-container>

					<fo:block-container position="absolute" left="7.0in" top="4.0in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:STTR_PDPICommitment"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.15in" top="4.0in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>

					<fo:block-container position="absolute" left="7.6in" top="4.0in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:STTR_PDPICommitment"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="7.75in" top="4.0in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container>
                    
                    
      				<fo:block-container position="absolute" left="0.3in" top="5.1in" height="24px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">11. In the joint research and development proposed in this project, does the small business perform at least 40% of the work and the research institution named in the application perform at least 30% of the work?*</fo:block>
					</fo:block-container>             
                    
					<fo:block-container position="absolute" left="7.0in" top="5.1in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:STTR_JointPerformancePercentage"/>
										<xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                   	<fo:block-container position="absolute" left="7.15in" top="5.1in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">Yes</fo:block>
					</fo:block-container>
 
					<fo:block-container position="absolute" left="7.6in" top="5.1in" height="12px">
						<fo:block font-size="9px" font-family="ZapfDingbats">
							<xsl:choose>
								<xsl:when test="boolean(0)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="radioButton">
										<xsl:with-param name="value" select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:STTR_JointPerformancePercentage"/>
										<xsl:with-param name="schemaChoice">N: No</xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
                   	<fo:block-container position="absolute" left="7.75in" top="5.1in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">No</fo:block>
					</fo:block-container>
                    <fo:block-container position="absolute" left="0.2in" top="5.5in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
					<fo:block-container position="absolute" left="0.3in" top="5.7in" height="24px" width="6.5in">
						<fo:block font-size="9px" font-family="arialuni">12. Provide DUNS Number of non-profit research partner for STTR.*</fo:block>
					</fo:block-container> 
					<fo:block-container position="absolute" left="0.3in" top="5.9in" height="12px">
						<fo:block font-size="9px" font-family="arialuni">
							<xsl:choose>
								<xsl:when test="not(//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DUNSID)">
									<fo:inline color="#FFFFFF">&#160;</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="//SBIR_STTR_Information_1_2:SBIR_STTR_Information_1_2/SBIR_STTR_Information_1_2:DUNSID"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:block-container>
				
					<fo:block-container position="absolute" left="0.2in" top="6.1in" width="7.9in" border="solid 1px black">
						<fo:block />
					</fo:block-container>
					
					
					
                 </fo:flow>
			</fo:page-sequence>
			            
		</fo:root>
	</xsl:template>

	<xsl:template name="radioButton">
		<xsl:param name="value"/>
		<xsl:param name="schemaChoice">Y: Yes</xsl:param>
		<xsl:choose>
			<xsl:when test="$value = $schemaChoice">
				<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats">&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="checkbox">
		<xsl:param name="value"/>
		<xsl:param name="schemaChoice">Y: Yes</xsl:param>
		<xsl:if test="$value = $schemaChoice">
			<fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="9px">&#x2714;</fo:inline>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatDate">
		<xsl:param name="value"/>
		<xsl:if test="$value != ''">
			<xsl:value-of select="format-number(number(substring($value,6,2)), '00')"/>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="format-number(number(substring($value,9,2)), '00')"/>
			<xsl:text>/</xsl:text>
			<xsl:value-of select="format-number(number(substring($value,1,4)), '0000')"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addBlankLines">
		<xsl:param name="numLines"/>
		<xsl:if test="string($numLines) != ''">
			<xsl:if test="$numLines &gt; 0">
				<fo:block xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
					<fo:leader leader-pattern="space"/>
				</fo:block>
				<xsl:call-template name="addBlankLines">
					<xsl:with-param name="numLines" select="$numLines - 1"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
