/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.gg;

import gov.grants.apply.services.applicantwebservices_v2.ObjectFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.gg.ApplicationWebServicesClient;
import org.kuali.research.grants.gg.ApplicationWebServicesHealthCheck;
import org.kuali.research.grants.gg.ApplicationWebServicesWsdlFetcher;
import org.kuali.research.grants.ws.JwsUtils;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.webservices.client.HttpWebServiceMessageSenderBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/grants/gg/GrantsGovConfiguration;", "", "()V", "applicationWebServicesClient", "Lorg/kuali/research/grants/gg/ApplicationWebServicesClient;", "grantsGovMarshaller", "Lorg/springframework/oxm/jaxb/Jaxb2Marshaller;", "grantsGovMessageSender", "Lorg/springframework/ws/transport/WebServiceMessageSender;", "applicationWebServicesHealthCheck", "Lorg/kuali/research/grants/gg/ApplicationWebServicesHealthCheck;", "applicationWebServicesWsdlFetcher", "Lorg/kuali/research/grants/gg/ApplicationWebServicesWsdlFetcher;", "grantsGovRestTemplate", "Lorg/springframework/web/client/RestTemplate;", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "grants"})
public class GrantsGovConfiguration {
    @Bean
    @NotNull
    public RestTemplate grantsGovRestTemplate() {
        return new RestTemplate();
    }

    @Bean
    @NotNull
    public Jaxb2Marshaller grantsGovMarshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath(JwsUtils.INSTANCE.getPackageName(Reflection.getOrCreateKotlinClass(ObjectFactory.class)));
        return marshaller;
    }

    @Bean
    @NotNull
    public ApplicationWebServicesHealthCheck applicationWebServicesHealthCheck(@NotNull ApplicationWebServicesClient applicationWebServicesClient) {
        Intrinsics.checkNotNullParameter((Object)applicationWebServicesClient, (String)"applicationWebServicesClient");
        return new ApplicationWebServicesHealthCheck(applicationWebServicesClient);
    }

    @Bean
    @NotNull
    public ApplicationWebServicesClient applicationWebServicesClient(@NotNull Jaxb2Marshaller grantsGovMarshaller, @NotNull WebServiceMessageSender grantsGovMessageSender) {
        Intrinsics.checkNotNullParameter((Object)grantsGovMarshaller, (String)"grantsGovMarshaller");
        Intrinsics.checkNotNullParameter((Object)grantsGovMessageSender, (String)"grantsGovMessageSender");
        ApplicationWebServicesClient client = new ApplicationWebServicesClient();
        client.setMarshaller((Marshaller)grantsGovMarshaller);
        client.setUnmarshaller((Unmarshaller)grantsGovMarshaller);
        client.getWebServiceTemplate().setMessageSender(grantsGovMessageSender);
        return client;
    }

    @Bean
    @NotNull
    public WebServiceMessageSender grantsGovMessageSender(@NotNull SslBundles sslBundles) {
        Intrinsics.checkNotNullParameter((Object)sslBundles, (String)"sslBundles");
        HttpWebServiceMessageSenderBuilder builder = new HttpWebServiceMessageSenderBuilder();
        builder.sslBundle(sslBundles.getBundle("gg"));
        WebServiceMessageSender webServiceMessageSender = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)webServiceMessageSender, (String)"build(...)");
        return webServiceMessageSender;
    }

    @Bean
    @NotNull
    public ApplicationWebServicesWsdlFetcher applicationWebServicesWsdlFetcher(@NotNull RestTemplate grantsGovRestTemplate) {
        Intrinsics.checkNotNullParameter((Object)grantsGovRestTemplate, (String)"grantsGovRestTemplate");
        return new ApplicationWebServicesWsdlFetcher(grantsGovRestTemplate);
    }
}

