/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys;

import jakarta.servlet.Filter;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.db.SchemaMultiTenantConnectionProvider;
import org.kuali.research.grants.sys.db.SchemaMultiTenantFlywayMigrationStrategy;
import org.kuali.research.grants.sys.db.TenantIdentifierResolver;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.environment.internal.EnvAwareWebFilter;
import org.kuali.research.grants.sys.environment.internal.EnvServiceImpl;
import org.kuali.research.grants.sys.environment.internal.MutableEnvService;
import org.kuali.research.grants.sys.properties.PropertiesDao;
import org.kuali.research.grants.sys.ssl.EnvAwareSslBundleLookupService;
import org.kuali.research.grants.sys.ssl.EnvAwareSslBundleLookupServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0017J\u001c\u0010\u0005\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u001a"}, d2={"Lorg/kuali/research/grants/sys/SysConfiguration;", "", "()V", "envAwareSslBundleLookupService", "Lorg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupService;", "envService", "Lorg/kuali/research/grants/sys/environment/EnvService;", "propertiesDao", "Lorg/kuali/research/grants/sys/properties/PropertiesDao;", "envAwareWebFilter", "Ljakarta/servlet/Filter;", "Lorg/kuali/research/grants/sys/environment/internal/MutableEnvService;", "internalTenant", "", "internalLane", "schemaMultiTenantConnectionProvider", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernatePropertiesCustomizer;", "datasource", "Ljavax/sql/DataSource;", "dataSourceProperties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "schemaMultiTenantFlywayMigrationStrategy", "Lorg/springframework/boot/autoconfigure/flyway/FlywayMigrationStrategy;", "kualiEnvironments", "", "tenantIdentifierResolver", "grants"})
public class SysConfiguration {
    @Bean
    @NotNull
    public MutableEnvService envService(@Value(value="${itenant}") @NotNull String internalTenant, @Value(value="${ilane}") @NotNull String internalLane) {
        Intrinsics.checkNotNullParameter((Object)internalTenant, (String)"internalTenant");
        Intrinsics.checkNotNullParameter((Object)internalLane, (String)"internalLane");
        return (MutableEnvService)new EnvServiceImpl(internalTenant, internalLane);
    }

    @Bean
    @NotNull
    public Filter envAwareWebFilter(@NotNull MutableEnvService envService) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return (Filter)new EnvAwareWebFilter(envService);
    }

    @Bean
    @NotNull
    public EnvAwareSslBundleLookupService envAwareSslBundleLookupService(@NotNull EnvService envService, @NotNull PropertiesDao propertiesDao) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)propertiesDao, (String)"propertiesDao");
        return (EnvAwareSslBundleLookupService)new EnvAwareSslBundleLookupServiceImpl(envService, propertiesDao);
    }

    @Bean
    @NotNull
    public HibernatePropertiesCustomizer tenantIdentifierResolver(@NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return (HibernatePropertiesCustomizer)new TenantIdentifierResolver(envService);
    }

    @Bean
    @NotNull
    public HibernatePropertiesCustomizer schemaMultiTenantConnectionProvider(@NotNull DataSource datasource, @NotNull DataSourceProperties dataSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        Intrinsics.checkNotNullParameter((Object)dataSourceProperties, (String)"dataSourceProperties");
        return (HibernatePropertiesCustomizer)new SchemaMultiTenantConnectionProvider(datasource, dataSourceProperties);
    }

    @Bean
    @NotNull
    public FlywayMigrationStrategy schemaMultiTenantFlywayMigrationStrategy(@Value(value="${kuali.environments}") @NotNull List<String> kualiEnvironments) {
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        return (FlywayMigrationStrategy)new SchemaMultiTenantFlywayMigrationStrategy(kualiEnvironments);
    }
}

