/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.environment.internal;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.environment.Env;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.environment.internal.EnvServiceImpl;
import org.kuali.research.grants.sys.environment.internal.MutableEnvService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kuali/research/grants/sys/environment/internal/EnvServiceImpl;", "Lorg/kuali/research/grants/sys/environment/EnvService;", "Lorg/kuali/research/grants/sys/environment/internal/MutableEnvService;", "internalTenant", "", "internalLane", "(Ljava/lang/String;Ljava/lang/String;)V", "internal", "Lorg/kuali/research/grants/sys/environment/Env;", "doInInternal", "R", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "env", "isSet", "", "lane", "removeEnv", "", "setEnv", "tenant", "EnvState", "grants"})
public final class EnvServiceImpl
implements EnvService,
MutableEnvService {
    @NotNull
    private final Env internal;

    public EnvServiceImpl(@NotNull String internalTenant, @NotNull String internalLane) {
        Intrinsics.checkNotNullParameter((Object)internalTenant, (String)"internalTenant");
        Intrinsics.checkNotNullParameter((Object)internalLane, (String)"internalLane");
        this.internal = new Env(internalTenant, internalLane);
    }

    public boolean isSet() {
        return EnvState.INSTANCE.getEnvs().get() != null;
    }

    @NotNull
    public String tenant() {
        return this.env().getTenant();
    }

    @NotNull
    public String lane() {
        return this.env().getLane();
    }

    @NotNull
    public Env env() {
        Env env = (Env)EnvState.INSTANCE.getEnvs().get();
        if (env == null) {
            throw new IllegalStateException("environment not set");
        }
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInInternal(@NotNull Function0<? extends R> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.isSet()) {
            Env previousEnv = this.env();
            try {
                this.setEnv(this.internal);
                Object object = task.invoke();
                return (R)object;
            }
            finally {
                this.setEnv(previousEnv);
            }
        }
        try {
            this.setEnv(this.internal);
            Object object = task.invoke();
            return (R)object;
        }
        finally {
            this.removeEnv();
        }
    }

    public void setEnv(@NotNull Env env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        EnvState.INSTANCE.getEnvs().set(env);
    }

    public void removeEnv() {
        EnvState.INSTANCE.getEnvs().remove();
    }
}

