/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.ssl;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.properties.PropertiesDao;
import org.kuali.research.grants.sys.properties.Property;
import org.kuali.research.grants.sys.ssl.EnvAwareSslBundleLookupService;
import org.kuali.research.grants.sys.ssl.EnvAwareSslBundleLookupServiceImpl;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupServiceImpl;", "Lorg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupService;", "envService", "Lorg/kuali/research/grants/sys/environment/EnvService;", "propertiesDao", "Lorg/kuali/research/grants/sys/properties/PropertiesDao;", "(Lorg/kuali/research/grants/sys/environment/EnvService;Lorg/kuali/research/grants/sys/properties/PropertiesDao;)V", "envName", "", "name", "getBundle", "Lorg/springframework/boot/ssl/SslBundle;", "propValue", "property", "Lorg/kuali/research/grants/sys/properties/Property;", "sslBundles", "Lorg/springframework/boot/ssl/SslBundles;", "EnvAwareSslBundleLookupServiceImpl", "EnvironmentSslBundles", "NonUpdatableBundle", "grants"})
@SourceDebugExtension(value={"SMAP\nEnvAwareSslBundleLookupServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvAwareSslBundleLookupServiceImpl.kt\norg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1179#2,2:90\n1253#2,4:92\n*S KotlinDebug\n*F\n+ 1 EnvAwareSslBundleLookupServiceImpl.kt\norg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupServiceImpl\n*L\n27#1:90,2\n27#1:92,4\n*E\n"})
public final class EnvAwareSslBundleLookupServiceImpl
implements EnvAwareSslBundleLookupService {
    @NotNull
    private final EnvService envService;
    @NotNull
    private final PropertiesDao propertiesDao;

    public EnvAwareSslBundleLookupServiceImpl(@NotNull EnvService envService, @NotNull PropertiesDao propertiesDao) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)propertiesDao, (String)"propertiesDao");
        this.envService = envService;
        this.propertiesDao = propertiesDao;
    }

    @NotNull
    public SslBundle getBundle(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SslBundle sslBundle = this.sslBundles().getBundle(this.envName(name));
        Intrinsics.checkNotNullExpressionValue((Object)sslBundle, (String)"getBundle(...)");
        return sslBundle;
    }

    /*
     * WARNING - void declaration
     */
    private final SslBundles sslBundles() {
        void $this$associateTo$iv$iv;
        List list = this.propertiesDao.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Property it = (Property)element$iv$iv;
            boolean bl = false;
            String string = it.getKey();
            Intrinsics.checkNotNull((Object)it);
            Pair pair = TuplesKt.to((Object)string, (Object)this.propValue(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map props = destination$iv$iv;
        ConfigurationPropertySource[] configurationPropertySourceArray = new ConfigurationPropertySource[]{new MapConfigurationPropertySource(props)};
        BindResult result = new Binder(configurationPropertySourceArray).bind("spring.ssl", SslProperties.class);
        if (!result.isBound()) {
            return (SslBundles)EnvAwareSslBundleLookupServiceImpl.INSTANCE.getEMPTY$grants();
        }
        Object object = result.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (SslBundles)new EnvironmentSslBundles((SslProperties)object);
    }

    private final String propValue(Property property) {
        String string;
        if (property.isFile()) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            String string2 = null;
            Path path = Files.createTempFile(string2, null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            Path file = path;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(file, property.getValue(), Arrays.copyOf(openOptionArray, openOptionArray.length));
            String string3 = file.toUri().getPath();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            string = StringsKt.decodeToString((byte[])property.getValue());
        }
        return string;
    }

    private final String envName(String name) {
        String tenant = this.envService.tenant();
        String lane = this.envService.lane();
        return tenant + "-" + lane + "-" + name;
    }
}

