/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.tenancy.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.tenancy.internal.service.MutableTenancyService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "mutableTenancyService", "Lorg/kuali/research/pdf/sys/tenancy/internal/service/MutableTenancyService;", "excludedPathPatterns", "", "", "<init>", "(Lorg/kuali/research/pdf/sys/tenancy/internal/service/MutableTenancyService;Ljava/util/Set;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "pdf"})
@SourceDebugExtension(value={"SMAP\nTenancyAwareWebFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyAwareWebFilter.kt\norg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1761#2,3:46\n*S KotlinDebug\n*F\n+ 1 TenancyAwareWebFilter.kt\norg/kuali/research/pdf/sys/tenancy/internal/filter/TenancyAwareWebFilter\n*L\n20#1:46,3\n*E\n"})
public class TenancyAwareWebFilter
extends OncePerRequestFilter {
    @NotNull
    private final MutableTenancyService mutableTenancyService;
    @NotNull
    private final Set<String> excludedPathPatterns;

    public TenancyAwareWebFilter(@NotNull MutableTenancyService mutableTenancyService, @Value(value="${kuali.tenancy.excluded.path-patterns}") @NotNull Set<String> excludedPathPatterns) {
        Intrinsics.checkNotNullParameter((Object)mutableTenancyService, (String)"mutableTenancyService");
        Intrinsics.checkNotNullParameter(excludedPathPatterns, (String)"excludedPathPatterns");
        this.mutableTenancyService = mutableTenancyService;
        this.excludedPathPatterns = excludedPathPatterns;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedPathPatterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        try {
            String host = request.getServerName();
            Intrinsics.checkNotNull((Object)host);
            if (!this.mutableTenancyService.isValidTenantHost(host)) {
                this.mutableTenancyService.removeTenantHost();
                response.sendError(404);
                return;
            }
            this.mutableTenancyService.setTenantHost(host);
        }
        catch (Throwable t) {
            this.mutableTenancyService.removeTenantHost();
            this.logger.error((Object)t.getMessage(), t);
            response.sendError(404);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

