/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.analyze;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.StampingProperties;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.analyze.AcroForm;
import org.kuali.research.pdf.analyze.AcroFormAnalyzer;
import org.kuali.research.pdf.analyze.AnalysisRequest;
import org.kuali.research.pdf.analyze.AnalysisResponse;
import org.kuali.research.pdf.analyze.AnalyzeService;
import org.kuali.research.pdf.analyze.EmbeddedAttachment;
import org.kuali.research.pdf.analyze.Encryption;
import org.kuali.research.pdf.analyze.ExternalAttachment;
import org.kuali.research.pdf.analyze.Info;
import org.kuali.research.pdf.analyze.Pdf;
import org.kuali.research.pdf.analyze.Supports;
import org.kuali.research.pdf.analyze.Version;
import org.kuali.research.pdf.analyze.XfaForm;
import org.kuali.research.pdf.analyze.XfaFormAnalyzerImpl;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.Props;
import org.kuali.research.pdf.sys.model.RequestMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0012J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/kuali/research/pdf/analyze/AnalyzeServiceImpl;", "Lorg/kuali/research/pdf/analyze/AnalyzeService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "acroFormAnalyzer", "Lorg/kuali/research/pdf/analyze/AcroFormAnalyzer;", "xfaFormAnalyzer", "Lorg/kuali/research/pdf/analyze/XfaFormAnalyzerImpl;", "<init>", "(Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/analyze/AcroFormAnalyzer;Lorg/kuali/research/pdf/analyze/XfaFormAnalyzerImpl;)V", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getAcroFormAnalyzer", "()Lorg/kuali/research/pdf/analyze/AcroFormAnalyzer;", "getXfaFormAnalyzer", "()Lorg/kuali/research/pdf/analyze/XfaFormAnalyzerImpl;", "analyze", "Lorg/kuali/research/pdf/analyze/AnalysisResponse;", "analysisRequest", "Lorg/kuali/research/pdf/analyze/AnalysisRequest;", "baseUrl", "", "doAnalyze", "getEmbeddedAttachments", "", "Lorg/kuali/research/pdf/analyze/EmbeddedAttachment;", "document", "Lcom/itextpdf/kernel/pdf/PdfDocument;", "getExternalAttachments", "Lorg/kuali/research/pdf/analyze/ExternalAttachment;", "getDocumentProperties", "Lcom/itextpdf/kernel/pdf/StampingProperties;", "pdf"})
@SourceDebugExtension(value={"SMAP\nAnalyzeServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeServiceImpl.kt\norg/kuali/research/pdf/analyze/AnalyzeServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n774#3:174\n865#3,2:175\n1563#3:177\n1634#3,3:178\n827#3:181\n855#3,2:182\n1563#3:184\n1634#3,3:185\n*S KotlinDebug\n*F\n+ 1 AnalyzeServiceImpl.kt\norg/kuali/research/pdf/analyze/AnalyzeServiceImpl\n*L\n129#1:174\n129#1:175,2\n130#1:177\n130#1:178,3\n152#1:181\n152#1:182,2\n153#1:184\n153#1:185,3\n*E\n"})
public class AnalyzeServiceImpl
implements AnalyzeService,
Logging {
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final AcroFormAnalyzer acroFormAnalyzer;
    @NotNull
    private final XfaFormAnalyzerImpl xfaFormAnalyzer;

    public AnalyzeServiceImpl(@Autowired @NotNull LinkService linkService, @Autowired @NotNull AcroFormAnalyzer acroFormAnalyzer, @Autowired @NotNull XfaFormAnalyzerImpl xfaFormAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)acroFormAnalyzer, (String)"acroFormAnalyzer");
        Intrinsics.checkNotNullParameter((Object)xfaFormAnalyzer, (String)"xfaFormAnalyzer");
        this.linkService = linkService;
        this.acroFormAnalyzer = acroFormAnalyzer;
        this.xfaFormAnalyzer = xfaFormAnalyzer;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public AcroFormAnalyzer getAcroFormAnalyzer() {
        return this.acroFormAnalyzer;
    }

    @NotNull
    public XfaFormAnalyzerImpl getXfaFormAnalyzer() {
        return this.xfaFormAnalyzer;
    }

    @Cacheable(value={"analyze"})
    @NotNull
    public AnalysisResponse analyze(@NotNull AnalysisRequest analysisRequest, @NotNull String baseUrl) {
        AnalysisResponse analysisResponse;
        Intrinsics.checkNotNullParameter((Object)analysisRequest, (String)"analysisRequest");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        try {
            analysisResponse = this.doAnalyze(analysisRequest, baseUrl);
        }
        catch (PdfException e) {
            this.getLogger().error((CharSequence)"Analyze failed", (Throwable)e);
            Link link = analysisRequest.getLink();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            analysisResponse = new AnalysisResponse(link, null, CollectionsKt.listOf((Object)Message.Companion.fatal(string, e.getMessageKey(), e.getProps())));
        }
        catch (Exception e) {
            this.getLogger().error((CharSequence)"Analyze failed", (Throwable)e);
            Link link = analysisRequest.getLink();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            analysisResponse = new AnalysisResponse(link, null, CollectionsKt.listOf((Object)Message.Companion.fatal$default((Message.Companion)Message.Companion, (String)string, (String)"unknown.error", null, (int)4, null)));
        }
        return analysisResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnalysisResponse doAnalyze(AnalysisRequest analysisRequest, String baseUrl) {
        InputStream inputStream;
        Object object;
        Object object2 = analysisRequest.getFileUpload();
        if (object2 != null && (object = object2.getData()) != null) {
            v0 = new ByteArrayInputStream((byte[])object);
        } else {
            Link link = analysisRequest.getLink();
            if (link != null) {
                Link it = link;
                boolean bl = false;
                v0 = this.getLinkService().input(it);
            } else {
                v0 = inputStream = null;
            }
        }
        if (inputStream == null) {
            throw new PdfException("unsupported.missing.data", MapsKt.emptyMap(), "No link or file upload provided", null, 8, null);
        }
        object2 = (Closeable)new PdfReader(inputStream);
        object = null;
        try {
            AnalysisResponse analysisResponse;
            PdfReader reader = (PdfReader)object2;
            boolean bl = false;
            Closeable closeable = (Closeable)new PdfDocument(reader, (DocumentProperties)this.getDocumentProperties());
            Throwable throwable = null;
            try {
                PdfDocument document = (PdfDocument)closeable;
                boolean bl2 = false;
                PdfDocumentInfo $this$doAnalyze_u24lambda_u241_u240_u240 = document.getDocumentInfo();
                boolean bl3 = false;
                Info info = new Info($this$doAnalyze_u24lambda_u241_u240_u240.getTitle(), $this$doAnalyze_u24lambda_u241_u240_u240.getAuthor(), $this$doAnalyze_u24lambda_u241_u240_u240.getSubject(), $this$doAnalyze_u24lambda_u241_u240_u240.getKeywords(), $this$doAnalyze_u24lambda_u241_u240_u240.getCreator(), $this$doAnalyze_u24lambda_u241_u240_u240.getProducer(), document.getNumberOfPages());
                PdfAcroForm pdfAcroForm = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)false);
                Pair pair = this.getAcroFormAnalyzer().getAcroForm(document, pdfAcroForm);
                AcroForm acroForm = (AcroForm)pair.component1();
                List afMessages = (List)pair.component2();
                String string = analysisRequest.getDocumentName();
                if (string == null) {
                    throw new PdfException("unsupported.missing.document.name", MapsKt.emptyMap(), "Document name is required", null, 8, null);
                }
                Pair pair2 = this.getXfaFormAnalyzer().getXfaForm(document, pdfAcroForm, baseUrl, analysisRequest.getShowXfaForm(), analysisRequest.getRootXfaUri(), string);
                XfaForm xfaForm = (XfaForm)pair2.component1();
                List xfMessages = (List)pair2.component2();
                boolean supportsAcroFilling = acroForm.getPresent();
                boolean supportsXfaFilling = xfaForm.getPresent();
                boolean supportsFlattening = supportsAcroFilling || supportsXfaFilling;
                boolean supportsWatermarking = true;
                LocalDateTime currentDateTime = LocalDateTime.now();
                Link link = analysisRequest.getLink();
                String string2 = document.getPdfVersion().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                Pdf pdf = new Pdf(new Version(string2), new Encryption(reader.isEncrypted()), info, acroForm, xfaForm, this.getExternalAttachments(document), this.getEmbeddedAttachments(document), new Supports(supportsAcroFilling, supportsXfaFilling, supportsFlattening, supportsWatermarking));
                String string3 = "Generated On " + currentDateTime;
                Intrinsics.checkNotNull((Object)currentDateTime);
                analysisResponse = new AnalysisResponse(link, pdf, CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)Message.Companion.info(string3, "generated.on", MapsKt.mapOf((Pair)Props.CUR_DATE_TIME.pair((Object)currentDateTime)))), (Iterable)afMessages), (Iterable)xfMessages));
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)closeable, throwable);
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    object = throwable4;
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            AnalysisResponse analysisResponse2 = analysisResponse;
            return analysisResponse2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<EmbeddedAttachment> getEmbeddedAttachments(@NotNull PdfDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        $this$filter$iv = document.getCatalog().getNameTree(PdfName.EmbeddedFiles).getNames().entrySet();
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-AnalyzeServiceImpl$getEmbeddedAttachments$1 = false;
            v0 = it.getValue();
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type com.itextpdf.kernel.pdf.PdfDictionary");
            if (!((PdfDictionary)v0).containsKey(PdfName.EF)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_9 = (Map.Entry)item$iv$iv;
            var23_23 = destination$iv$iv;
            $i$a$-map-AnalyzeServiceImpl$getEmbeddedAttachments$2 = false;
            key = (PdfString)var9_9.getKey();
            value = (PdfObject)var9_9.getValue();
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.itextpdf.kernel.pdf.PdfDictionary");
            $this$getEmbeddedAttachments_u24lambda_u241_u240 = (PdfDictionary)value;
            $i$a$-with-AnalyzeServiceImpl$getEmbeddedAttachments$2$1 = false;
            v1 = key.getValue();
            v2 = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getValue(...)");
            v3 = $this$getEmbeddedAttachments_u24lambda_u241_u240.getAsString(PdfName.F);
            v4 = v3 != null ? v3.getValue() : null;
            v5 = $this$getEmbeddedAttachments_u24lambda_u241_u240.getAsString(PdfName.UF);
            v6 = v5 != null ? v5.getValue() : null;
            var15_15 = $this$getEmbeddedAttachments_u24lambda_u241_u240.getAsString(PdfName.ModDate);
            if (var15_15 == null) ** GOTO lbl-1000
            var16_16 = var15_15;
            var17_17 = v6;
            var18_18 = v4;
            var19_19 = v2;
            $i$a$-let-AnalyzeServiceImpl$getEmbeddedAttachments$2$1$1 = false;
            var21_21 /* !! */  = PdfDate.decode((String)it.getValue());
            v2 = var19_19;
            v4 = var18_18;
            v6 = var17_17;
            var22_22 = var21_21 /* !! */ ;
            if (var22_22 != null) {
                it = var22_22;
                var17_17 = v6;
                var18_18 = v4;
                var19_19 = v2;
                $i$a$-let-AnalyzeServiceImpl$getEmbeddedAttachments$2$1$2 = false;
                var21_21 /* !! */  = LocalDate.ofInstant(it.toInstant(), it.getTimeZone().toZoneId());
                v2 = var19_19;
                v4 = var18_18;
                v6 = var17_17;
                v7 /* !! */  = var21_21 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                v7 /* !! */  = null;
            }
            v8 = $this$getEmbeddedAttachments_u24lambda_u241_u240.getAsString(PdfName.Subtype);
            v9 = $this$getEmbeddedAttachments_u24lambda_u241_u240.getAsNumber(PdfName.Size);
            var24_24 = v9 != null ? Integer.valueOf((int)v9.getValue()) : null;
            var25_25 = Intrinsics.areEqual((Object)PdfName.AF, (Object)$this$getEmbeddedAttachments_u24lambda_u241_u240.get(PdfName.AFRelationship));
            var26_26 = v8 != null ? v8.getValue() : null;
            var27_27 = v7 /* !! */ ;
            var28_28 = v6;
            var29_29 = v4;
            var30_30 = v2;
            var23_23.add(new EmbeddedAttachment(var30_30, var29_29, var28_28, (LocalDate)var27_27, var26_26, var25_25, var24_24));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public List<ExternalAttachment> getExternalAttachments(@NotNull PdfDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        $this$filterNot$iv = document.getCatalog().getNameTree(PdfName.EmbeddedFiles).getNames().entrySet();
        $i$f$filterNot = false;
        var4_4 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filterNot-AnalyzeServiceImpl$getExternalAttachments$1 = false;
            v0 = it.getValue();
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type com.itextpdf.kernel.pdf.PdfDictionary");
            if (((PdfDictionary)v0).containsKey(PdfName.EF)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_9 = (Map.Entry)item$iv$iv;
            var23_23 = destination$iv$iv;
            $i$a$-map-AnalyzeServiceImpl$getExternalAttachments$2 = false;
            key = (PdfString)var9_9.getKey();
            value = (PdfObject)var9_9.getValue();
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.itextpdf.kernel.pdf.PdfDictionary");
            $this$getExternalAttachments_u24lambda_u241_u240 = (PdfDictionary)value;
            $i$a$-with-AnalyzeServiceImpl$getExternalAttachments$2$1 = false;
            v1 = key.getValue();
            v2 = v1;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getValue(...)");
            v3 = $this$getExternalAttachments_u24lambda_u241_u240.getAsString(PdfName.F);
            v4 = v3 != null ? v3.getValue() : null;
            v5 = $this$getExternalAttachments_u24lambda_u241_u240.getAsString(PdfName.UF);
            v6 = v5 != null ? v5.getValue() : null;
            var15_15 = $this$getExternalAttachments_u24lambda_u241_u240.getAsString(PdfName.ModDate);
            if (var15_15 == null) ** GOTO lbl-1000
            var16_16 = var15_15;
            var17_17 = v6;
            var18_18 = v4;
            var19_19 = v2;
            $i$a$-let-AnalyzeServiceImpl$getExternalAttachments$2$1$1 = false;
            var21_21 /* !! */  = PdfDate.decode((String)it.getValue());
            v2 = var19_19;
            v4 = var18_18;
            v6 = var17_17;
            var22_22 = var21_21 /* !! */ ;
            if (var22_22 != null) {
                it = var22_22;
                var17_17 = v6;
                var18_18 = v4;
                var19_19 = v2;
                $i$a$-let-AnalyzeServiceImpl$getExternalAttachments$2$1$2 = false;
                var21_21 /* !! */  = LocalDate.ofInstant(it.toInstant(), it.getTimeZone().toZoneId());
                v2 = var19_19;
                v4 = var18_18;
                v6 = var17_17;
                v7 /* !! */  = var21_21 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                v7 /* !! */  = null;
            }
            v8 = $this$getExternalAttachments_u24lambda_u241_u240.getAsString(PdfName.Subtype);
            var24_24 = Intrinsics.areEqual((Object)PdfName.AF, (Object)$this$getExternalAttachments_u24lambda_u241_u240.get(PdfName.AFRelationship));
            var25_25 = v8 != null ? v8.getValue() : null;
            var26_26 = v7 /* !! */ ;
            var27_27 = v6;
            var28_28 = v4;
            var29_29 = v2;
            var23_23.add(new ExternalAttachment(var29_29, var28_28, var27_27, var26_26, var25_25, var24_24));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public StampingProperties getDocumentProperties() {
        StampingProperties stampingProperties;
        StampingProperties $this$getDocumentProperties_u24lambda_u240 = stampingProperties = new StampingProperties();
        boolean bl = false;
        $this$getDocumentProperties_u24lambda_u240.setEventCountingMetaInfo((IMetaInfo)new RequestMetaData(null, null, MapsKt.emptyMap(), 3, null));
        return stampingProperties;
    }
}

