/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.authnintegration.platform.internal.service;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.authnintegration.platform.PlatformAuthnBearerToken;
import org.kuali.research.pdf.authnintegration.platform.ResPlatformAuthnUser;
import org.kuali.research.pdf.authnintegration.platform.internal.service.ResPlatformMutableAuthnService;
import org.kuali.research.pdf.authnintegration.platform.internal.service.ResPlatformMutableAuthnServiceImpl;
import org.kuali.research.pdf.sys.jwt.JwtService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001dB#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u001c\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0012J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u000f\u0010\u001b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/kuali/research/pdf/authnintegration/platform/internal/service/ResPlatformMutableAuthnServiceImpl;", "Lorg/kuali/research/pdf/authnintegration/platform/internal/service/ResPlatformMutableAuthnService;", "platformSystemToSystemSecret", "", "platformSystemToSystemExpirationSeconds", "", "jwtService", "Lorg/kuali/research/pdf/sys/jwt/JwtService;", "<init>", "(Ljava/lang/String;JLorg/kuali/research/pdf/sys/jwt/JwtService;)V", "getPlatformSystemToSystemSecret", "()Ljava/lang/String;", "getPlatformSystemToSystemExpirationSeconds", "()J", "getJwtService", "()Lorg/kuali/research/pdf/sys/jwt/JwtService;", "isSet", "", "authnUser", "Lkotlin/Pair;", "Lorg/kuali/research/pdf/authnintegration/platform/PlatformAuthnBearerToken;", "Lorg/kuali/research/pdf/authnintegration/platform/ResPlatformAuthnUser;", "setAuthnUser", "", "resPlatformAuthnUser", "setAuthnUserUnsafe", "removeAuthnUser", "system2SystemToken", "system2SystemToken-uCRbvmQ", "AuthnUserState", "pdf"})
public class ResPlatformMutableAuthnServiceImpl
implements ResPlatformMutableAuthnService {
    @NotNull
    private final String platformSystemToSystemSecret;
    private final long platformSystemToSystemExpirationSeconds;
    @NotNull
    private final JwtService jwtService;

    public ResPlatformMutableAuthnServiceImpl(@Value(value="${kuali.platform.authn.service2service.secret}") @NotNull String platformSystemToSystemSecret, @Value(value="${kuali.platform.authn.service2service.expiration.seconds}") long platformSystemToSystemExpirationSeconds, @NotNull JwtService jwtService) {
        Intrinsics.checkNotNullParameter((Object)platformSystemToSystemSecret, (String)"platformSystemToSystemSecret");
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        this.platformSystemToSystemSecret = platformSystemToSystemSecret;
        this.platformSystemToSystemExpirationSeconds = platformSystemToSystemExpirationSeconds;
        this.jwtService = jwtService;
    }

    @NotNull
    public String getPlatformSystemToSystemSecret() {
        return this.platformSystemToSystemSecret;
    }

    public long getPlatformSystemToSystemExpirationSeconds() {
        return this.platformSystemToSystemExpirationSeconds;
    }

    @NotNull
    public JwtService getJwtService() {
        return this.jwtService;
    }

    public boolean isSet() {
        return AuthnUserState.INSTANCE.getResPlatformAuthnUsers().get() != null;
    }

    @NotNull
    public Pair<PlatformAuthnBearerToken, ResPlatformAuthnUser> authnUser() {
        Pair pair = (Pair)AuthnUserState.INSTANCE.getResPlatformAuthnUsers().get();
        if (pair == null) {
            throw new IllegalStateException("authn user not set");
        }
        return pair;
    }

    public void setAuthnUser(@NotNull Pair<PlatformAuthnBearerToken, ResPlatformAuthnUser> resPlatformAuthnUser) {
        Intrinsics.checkNotNullParameter(resPlatformAuthnUser, (String)"resPlatformAuthnUser");
        this.setAuthnUserUnsafe(resPlatformAuthnUser);
    }

    private void setAuthnUserUnsafe(Pair<PlatformAuthnBearerToken, ResPlatformAuthnUser> resPlatformAuthnUser) {
        AuthnUserState.INSTANCE.getResPlatformAuthnUsers().set(resPlatformAuthnUser);
    }

    public void removeAuthnUser() {
        AuthnUserState.INSTANCE.getResPlatformAuthnUsers().remove();
    }

    @NotNull
    public String system2SystemToken-uCRbvmQ() {
        return PlatformAuthnBearerToken.constructor-impl((String)this.getJwtService().createToken(this.getPlatformSystemToSystemSecret(), this.getPlatformSystemToSystemExpirationSeconds()));
    }
}

