/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;

public class KualiPersistenceBrokerFactoryImpl extends PersistenceBrokerFactoryDefaultImpl {
    private static final Logger LOG = LogManager.getLogger(KualiPersistenceBrokerFactoryImpl.class);

    /**
     * @see org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl#createPersistenceBroker(org.apache.ojb.broker.PBKey)
     */
    public PersistenceBrokerInternal createPersistenceBroker(PBKey pbKey) throws PBFactoryException {
        PersistenceBrokerInternal pb = super.createPersistenceBroker(pbKey);

        PersistenceBrokerHandle pbh = (PersistenceBrokerHandle) pb;
        KualiPersistenceBrokerImpl realBroker = (KualiPersistenceBrokerImpl) pbh.getInnermostDelegate();

        LOG.debug((realBroker.isFresh() ? "created " : "reusing ") + "persistence broker " + pb.getClass().getName() + "@" + pb.hashCode());

        return pb;
    }
}
