/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.common.assignee.Assignee;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.entity.EntityQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.responsibility.ResponsibilityAction;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.services.IdentityManagementService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class IdentityManagementServiceImpl
implements IdentityManagementService {
    private static final Logger LOG = LogManager.getLogger(IdentityManagementServiceImpl.class);
    private PermissionService permissionService;
    private ResponsibilityService responsibilityService;
    private IdentityService identityService;
    private GroupService groupService;

    @Override
    public void flushAllCaches() {
    }

    @Override
    public void flushEntityPrincipalCaches() {
    }

    @Override
    public void flushGroupCaches() {
    }

    @Override
    public void flushPermissionCaches() {
    }

    @Override
    public void flushResponsibilityCaches() {
    }

    @Override
    public boolean hasPermission(String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails) {
        if (LOG.isDebugEnabled()) {
            this.logHasPermissionCheck("Permission", principalId, namespaceCode, permissionName, permissionDetails);
        }
        boolean hasPerm = this.getPermissionService().hasPermission(principalId, namespaceCode, permissionName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result: " + hasPerm);
        }
        return hasPerm;
    }

    @Override
    public boolean isAuthorized(String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        if (qualification == null || qualification.isEmpty()) {
            return this.hasPermission(principalId, namespaceCode, permissionName, permissionDetails);
        }
        if (LOG.isDebugEnabled()) {
            this.logAuthorizationCheck("Permission", principalId, namespaceCode, permissionName, permissionDetails, qualification);
        }
        boolean isAuthorized = this.getPermissionService().isAuthorized(principalId, namespaceCode, permissionName, qualification);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result: " + isAuthorized);
        }
        return isAuthorized;
    }

    @Override
    public boolean hasPermissionByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        if (LOG.isDebugEnabled()) {
            this.logHasPermissionCheck("Perm Templ", principalId, namespaceCode, permissionTemplateName, permissionDetails);
        }
        boolean hasPerm = this.getPermissionService().hasPermissionByTemplate(principalId, namespaceCode, permissionTemplateName, permissionDetails);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result: " + hasPerm);
        }
        return hasPerm;
    }

    @Override
    public boolean isAuthorizedByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        if (qualification == null || qualification.isEmpty()) {
            return this.hasPermissionByTemplate(principalId, namespaceCode, permissionTemplateName, new HashMap<String, String>(permissionDetails));
        }
        if (LOG.isDebugEnabled()) {
            this.logAuthorizationCheck("Perm Templ", principalId, namespaceCode, permissionTemplateName, new HashMap<String, String>(permissionDetails), new HashMap<String, String>(qualification));
        }
        boolean isAuthorized = this.getPermissionService().isAuthorizedByTemplate(principalId, namespaceCode, permissionTemplateName, new HashMap<String, String>(permissionDetails), new HashMap<String, String>(qualification));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Result: " + isAuthorized);
        }
        return isAuthorized;
    }

    @Override
    public List<Permission> getAuthorizedPermissions(String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        return this.getPermissionService().getAuthorizedPermissions(principalId, namespaceCode, permissionName, qualification);
    }

    @Override
    public List<Permission> getAuthorizedPermissionsByTemplate(String principalId, String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        return this.getPermissionService().getAuthorizedPermissionsByTemplate(principalId, namespaceCode, permissionTemplateName, permissionDetails, qualification);
    }

    @Override
    public boolean isPermissionDefinedForTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails) {
        return this.getPermissionService().isPermissionDefinedByTemplate(namespaceCode, permissionTemplateName, permissionDetails);
    }

    @Override
    public List<Assignee> getPermissionAssignees(String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        return this.permissionService.getPermissionAssignees(namespaceCode, permissionName, qualification);
    }

    @Override
    public List<Assignee> getPermissionAssigneesForTemplate(String namespaceCode, String permissionTemplateName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        return this.permissionService.getPermissionAssigneesByTemplate(namespaceCode, permissionTemplateName, new HashMap<String, String>(permissionDetails), new HashMap<String, String>(qualification));
    }

    @Override
    public boolean isMemberOfGroup(String principalId, String groupId) {
        return this.getGroupService().isMemberOfGroup(principalId, groupId);
    }

    @Override
    public boolean isMemberOfGroup(String principalId, String namespaceCode, String groupName) {
        Group group = this.getGroupByName(namespaceCode, groupName);
        return group == null ? false : this.isMemberOfGroup(principalId, group.getId());
    }

    @Override
    public boolean isGroupMemberOfGroup(String potentialMemberId, String potentialParentId) {
        return this.getGroupService().isGroupMemberOfGroup(potentialMemberId, potentialParentId);
    }

    @Override
    public List<String> getGroupMemberPrincipalIds(String groupId) {
        return this.getGroupService().getMemberPrincipalIds(groupId);
    }

    @Override
    public List<String> getDirectGroupMemberPrincipalIds(String groupId) {
        return this.getGroupService().getDirectMemberPrincipalIds(groupId);
    }

    @Override
    public List<String> getGroupIdsForPrincipal(String principalId) {
        return this.getGroupService().getGroupIdsByPrincipalId(principalId);
    }

    @Override
    public List<String> getGroupIdsForPrincipal(String principalId, String namespaceCode) {
        return this.getGroupService().getGroupIdsByPrincipalIdAndNamespaceCode(principalId, namespaceCode);
    }

    public List<Group> getGroupsForPrincipal(String principalId) {
        return this.getGroupService().getGroupsByPrincipalId(principalId);
    }

    public List<Group> getGroupsForPrincipal(String principalId, String namespaceCode) {
        return this.getGroupService().getGroupsByPrincipalIdAndNamespaceCode(principalId, namespaceCode);
    }

    @Override
    public List<String> getMemberGroupIds(String groupId) {
        return this.getGroupService().getMemberGroupIds(groupId);
    }

    @Override
    public List<String> getDirectMemberGroupIds(String groupId) {
        return this.getGroupService().getDirectMemberGroupIds(groupId);
    }

    @Override
    public Group getGroup(String groupId) {
        return this.getGroupService().getGroup(groupId);
    }

    @Override
    public Group getGroupByName(String namespaceCode, String groupName) {
        return this.getGroupService().getGroupByNamespaceCodeAndName(namespaceCode, groupName);
    }

    @Override
    public List<String> getParentGroupIds(String groupId) {
        return this.getGroupService().getParentGroupIds(groupId);
    }

    @Override
    public List<String> getDirectParentGroupIds(String groupId) {
        return this.getGroupService().getDirectParentGroupIds(groupId);
    }

    @Override
    public boolean addGroupToGroup(String childId, String parentId) {
        return this.getGroupService().addGroupToGroup(childId, parentId);
    }

    @Override
    public boolean addPrincipalToGroup(String principalId, String groupId) {
        return this.getGroupService().addPrincipalToGroup(principalId, groupId);
    }

    @Override
    public boolean removeGroupFromGroup(String childId, String parentId) {
        return this.getGroupService().removeGroupFromGroup(childId, parentId);
    }

    @Override
    public boolean removePrincipalFromGroup(String principalId, String groupId) {
        return this.getGroupService().removePrincipalFromGroup(principalId, groupId);
    }

    @Override
    public Group createGroup(Group group) {
        return this.getGroupService().createGroup(group);
    }

    @Override
    public void removeAllMembers(String groupId) {
        this.getGroupService().removeAllMembers(groupId);
    }

    @Override
    public Group updateGroup(String groupId, Group group) {
        return this.getGroupService().updateGroup(groupId, group);
    }

    @Override
    public Principal getPrincipal(String principalId) {
        return this.getIdentityService().getPrincipal(principalId);
    }

    @Override
    public Principal getPrincipalByPrincipalName(String principalName) {
        return this.getIdentityService().getPrincipalByPrincipalName(principalName);
    }

    @Override
    public Principal getPrincipalByPrincipalNameAndPassword(String principalName, String password) {
        return this.getIdentityService().getPrincipalByPrincipalNameAndPassword(principalName, password);
    }

    @Override
    public EntityDefault getEntityDefaultInfo(String entityId) {
        return this.getIdentityService().getEntityDefault(entityId);
    }

    @Override
    public EntityDefault getEntityDefaultInfoByPrincipalId(String principalId) {
        return this.getIdentityService().getEntityDefaultByPrincipalId(principalId);
    }

    @Override
    public EntityDefault getEntityDefaultInfoByPrincipalName(String principalName) {
        return this.getIdentityService().getEntityDefaultByPrincipalName(principalName);
    }

    @Override
    public EntityDefaultQueryResults findEntityDefaults(QueryByCriteria queryByCriteria) {
        return this.getIdentityService().findEntityDefaults(queryByCriteria);
    }

    @Override
    public Entity getEntity(String entityId) {
        return this.getIdentityService().getEntity(entityId);
    }

    @Override
    public Entity getEntityByPrincipalId(String principalId) {
        return this.getIdentityService().getEntityByPrincipalId(principalId);
    }

    @Override
    public Entity getEntityByPrincipalName(String principalName) {
        return this.getIdentityService().getEntityByPrincipalName(principalName);
    }

    @Override
    public EntityQueryResults findEntities(QueryByCriteria queryByCriteria) {
        return this.getIdentityService().findEntities(queryByCriteria);
    }

    @Override
    public CodedAttribute getAddressType(String code) {
        return this.getIdentityService().getAddressType(code);
    }

    @Override
    public CodedAttribute getEmailType(String code) {
        return this.getIdentityService().getEmailType(code);
    }

    @Override
    public EntityAffiliationType getAffiliationType(String code) {
        return this.getIdentityService().getAffiliationType(code);
    }

    @Override
    public CodedAttribute getCitizenshipStatus(String code) {
        return CodedAttribute.Builder.create((CodedAttributeContract)this.getIdentityService().getCitizenshipStatus(code)).build();
    }

    @Override
    public CodedAttribute getEmploymentStatus(String code) {
        return this.getIdentityService().getEmploymentStatus(code);
    }

    @Override
    public CodedAttribute getEmploymentType(String code) {
        return this.getIdentityService().getEmploymentType(code);
    }

    @Override
    public CodedAttribute getEntityNameType(String code) {
        return this.getIdentityService().getNameType(code);
    }

    @Override
    public CodedAttribute getEntityType(String code) {
        return this.getIdentityService().getEntityType(code);
    }

    @Override
    public EntityExternalIdentifierType getExternalIdentifierType(String code) {
        return this.getIdentityService().getExternalIdentifierType(code);
    }

    @Override
    public CodedAttribute getPhoneType(String code) {
        return this.getIdentityService().getPhoneType(code);
    }

    @Override
    public Responsibility getResponsibility(String responsibilityId) {
        return this.getResponsibilityService().getResponsibility(responsibilityId);
    }

    @Override
    public boolean hasResponsibility(String principalId, String namespaceCode, String responsibilityName, Map<String, String> qualification) {
        return this.getResponsibilityService().hasResponsibility(principalId, namespaceCode, responsibilityName, qualification);
    }

    @Override
    public Responsibility getResponsibilityByName(String namespaceCode, String responsibilityName) {
        return this.getResponsibilityService().findRespByNamespaceCodeAndName(namespaceCode, responsibilityName);
    }

    @Override
    public List<ResponsibilityAction> getResponsibilityActions(String namespaceCode, String responsibilityName, Map<String, String> qualification, Map<String, String> responsibilityDetails) {
        return this.getResponsibilityService().getResponsibilityActions(namespaceCode, responsibilityName, qualification);
    }

    @Override
    public List<ResponsibilityAction> getResponsibilityActionsByTemplate(String namespaceCode, String responsibilityTemplateName, Map<String, String> qualification, Map<String, String> responsibilityDetails) {
        return this.getResponsibilityService().getResponsibilityActionsByTemplate(namespaceCode, responsibilityTemplateName, qualification, responsibilityDetails);
    }

    @Override
    public boolean hasResponsibilityByTemplate(String principalId, String namespaceCode, String responsibilityTemplateName, Map<String, String> qualification, Map<String, String> responsibilityDetails) {
        return this.getResponsibilityService().hasResponsibilityByTemplate(principalId, namespaceCode, responsibilityTemplateName, qualification, responsibilityDetails);
    }

    protected void logAuthorizationCheck(String checkType, String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails, Map<String, String> qualification) {
        Principal principal;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Is AuthZ for ").append(checkType).append(": ").append(namespaceCode).append("/").append(permissionName).append('\n');
        sb.append("             Principal:  ").append(principalId);
        if (principalId != null && (principal = this.getPrincipal(principalId)) != null) {
            sb.append(" (").append(principal.getPrincipalName()).append(')');
        }
        sb.append('\n');
        sb.append("             Details:\n");
        if (permissionDetails != null) {
            sb.append(permissionDetails);
        } else {
            sb.append("                         [null]\n");
        }
        sb.append("             Qualifiers:\n");
        if (qualification != null && !qualification.isEmpty()) {
            sb.append(qualification);
        } else {
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((CharSequence)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug(sb.toString());
        }
    }

    protected void logHasPermissionCheck(String checkType, String principalId, String namespaceCode, String permissionName, Map<String, String> permissionDetails) {
        Principal principal;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Has Perm for ").append(checkType).append(": ").append(namespaceCode).append("/").append(permissionName).append('\n');
        sb.append("             Principal:  ").append(principalId);
        if (principalId != null && (principal = this.getPrincipal(principalId)) != null) {
            sb.append(" (").append(principal.getPrincipalName()).append(')');
        }
        sb.append('\n');
        sb.append("             Details:\n");
        if (permissionDetails != null) {
            sb.append(permissionDetails);
        } else {
            sb.append("                         [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((CharSequence)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug(sb.toString());
        }
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    public GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public ResponsibilityService getResponsibilityService() {
        if (this.responsibilityService == null) {
            this.responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return this.responsibilityService;
    }
}

