/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.role;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.framework.role.RoleTypeService;

public abstract class PassThruRoleTypeServiceBase
implements RoleTypeService {
    private static final Logger LOG = Logger.getLogger(PassThruRoleTypeServiceBase.class);
    public static final String UNMATCHABLE_QUALIFICATION = "!~!~!~!~!~";

    public abstract Map<String, String> convertQualificationForMemberRoles(String var1, String var2, String var3, String var4, Map<String, String> var5);

    public List<RoleMembership> getMatchingRoleMemberships(Map<String, String> qualification, List<RoleMembership> roleMemberList) {
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        if (roleMemberList == null) {
            throw new RiceIllegalArgumentException("roleMemberList was null");
        }
        return Collections.unmodifiableList(new ArrayList<RoleMembership>(roleMemberList));
    }

    public boolean doesRoleQualifierMatchQualification(Map<String, String> qualification, Map<String, String> roleQualifier) {
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        if (roleQualifier == null) {
            throw new RiceIllegalArgumentException("roleQualifier was null");
        }
        return true;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (groupIds == null) {
            throw new RiceIllegalArgumentException("groupIds was null or blank");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        return false;
    }

    public boolean isDerivedRoleType() {
        return false;
    }

    public List<String> getAcceptedAttributeNames() {
        return Collections.emptyList();
    }

    public List<KimAttributeField> getAttributeDefinitions(String kimTypeId) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        return Collections.emptyList();
    }

    public String getWorkflowDocumentTypeName() {
        return null;
    }

    public List<String> getWorkflowRoutingAttributes(String routeLevel) {
        if (StringUtils.isBlank((String)routeLevel)) {
            throw new RiceIllegalArgumentException("routeLevel was null or blank");
        }
        return Collections.emptyList();
    }

    public boolean supportsAttributes(List<String> attributeNames) {
        if (attributeNames == null) {
            throw new RiceIllegalArgumentException("attributeNames was null");
        }
        return true;
    }

    public Map<String, String> translateInputAttributes(Map<String, String> inputAttributes) {
        if (inputAttributes == null) {
            throw new RiceIllegalArgumentException("inputAttributes was null");
        }
        return inputAttributes;
    }

    public List<RemotableAttributeError> validateAttributes(String kimTypeId, Map<String, String> attributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (attributes == null) {
            throw new RiceIllegalArgumentException("attributes was null or blank");
        }
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateAttributesAgainstExisting(String kimTypeId, Map<String, String> newAttributes, Map<String, String> oldAttributes) {
        if (StringUtils.isBlank((String)kimTypeId)) {
            throw new RiceIllegalArgumentException("kimTypeId was null or blank");
        }
        if (newAttributes == null) {
            throw new RiceIllegalArgumentException("newAttributes was null or blank");
        }
        if (oldAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes was null or blank");
        }
        return Collections.emptyList();
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        return false;
    }
}

