/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.client.acegi;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthenticationProvider;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.StatelessTicketCache;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.kim.client.acegi.KualiCasAuthoritiesPopulator;
import org.kuali.rice.kim.client.acegi.KualiTicketResponse;

public class KualiCasAuthenticationProvider
extends CasAuthenticationProvider {
    private static final Log logger = LogFactory.getLog(KualiCasAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        StatelessTicketCache statelessTicketCache = this.getStatelessTicketCache();
        String key = this.getKey();
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && !"_cas_stateful_".equals(authentication.getPrincipal().toString()) && !"_cas_stateless_".equals(authentication.getPrincipal().toString())) {
            return null;
        }
        if (authentication instanceof CasAuthenticationToken) {
            if (key.hashCode() == ((CasAuthenticationToken)authentication).getKeyHash()) {
                return authentication;
            }
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.incorrectKey", "The presented CasAuthenticationToken does not contain the expected key"));
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.noServiceTicket", "Failed to provide a CAS service ticket to validate"));
        }
        boolean stateless = false;
        if (authentication instanceof UsernamePasswordAuthenticationToken && "_cas_stateless_".equals(authentication.getPrincipal())) {
            stateless = true;
        }
        CasAuthenticationToken result = null;
        if (stateless) {
            result = statelessTicketCache.getByTicketId(authentication.getCredentials().toString());
        }
        if (result == null) {
            result = this.authenticateNow(authentication);
            result.setDetails(authentication.getDetails());
        }
        if (stateless) {
            statelessTicketCache.putTicketInCache(result);
        }
        return result;
    }

    private CasAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        KualiTicketResponse response = (KualiTicketResponse)this.getTicketValidator().confirmTicketValid(authentication.getCredentials().toString());
        this.getCasProxyDecider().confirmProxyListTrusted(response.getProxyList());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("authenticationNOW:" + (Object)((Object)response)));
        }
        logger.debug((Object)"\n\npopulating authorities\n\n");
        UserDetails userDetails = ((KualiCasAuthoritiesPopulator)this.getCasAuthoritiesPopulator()).getUserDetails(response);
        return new CasAuthenticationToken(this.getKey(), (Object)userDetails, authentication.getCredentials(), userDetails.getAuthorities(), userDetails, response.getProxyList(), response.getProxyGrantingTicketIou());
    }
}

