/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.client.acegi;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class KualiTestAuthenticationProvider
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getPrincipal().equals(authentication.getCredentials())) {
            UsernamePasswordAuthenticationToken auth = this.authenticateNow(authentication);
            return auth;
        }
        return authentication;
    }

    private UsernamePasswordAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_KUALI_USER")});
    }

    public boolean supports(Class authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

