/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePair;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePairValidatingAdapter;
import org.kuali.rice.kim.api.permission.PermissionContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.RolePermissionsXmlDTO;

@XmlTransient
public abstract class RolePermissionXmlDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="permissionId")
    @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
    private String permissionId;
    @XmlElement(name="permissionName")
    @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
    private NameAndNamespacePair permissionNameAndNamespace;

    public RolePermissionXmlDTO() {
    }

    public RolePermissionXmlDTO(PermissionContract permission, boolean populateIds) {
        if (permission == null) {
            throw new IllegalArgumentException("Cannot construct a role permission with a null permission");
        }
        if (populateIds) {
            this.permissionId = permission.getId();
        }
        this.permissionNameAndNamespace = new NameAndNamespacePair(permission.getNamespaceCode(), permission.getName());
    }

    public String getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(String permissionId) {
        this.permissionId = permissionId;
    }

    public NameAndNamespacePair getPermissionNameAndNamespace() {
        return this.permissionNameAndNamespace;
    }

    public void setPermissionNameAndNamespace(NameAndNamespacePair permissionNameAndNamespace) {
        this.permissionNameAndNamespace = permissionNameAndNamespace;
    }

    public String getPermissionName() {
        return this.permissionNameAndNamespace != null ? this.permissionNameAndNamespace.getName() : null;
    }

    public String getPermissionNamespaceCode() {
        return this.permissionNameAndNamespace != null ? this.permissionNameAndNamespace.getNamespaceCode() : null;
    }

    public abstract String getRoleId();

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="RolePermissionType", propOrder={"permissionId", "permissionNameAndNamespace"})
    public static class WithinRole
    extends RolePermissionXmlDTO {
        private static final long serialVersionUID = 1L;
        @XmlTransient
        private String roleId;

        public WithinRole() {
        }

        public WithinRole(PermissionContract permission, boolean populateIds) {
            super(permission, populateIds);
        }

        void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
            if (parent instanceof RolePermissionsXmlDTO) {
                this.roleId = ((RolePermissionXmlDTO)parent).getRoleId();
            }
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="StandaloneRolePermissionType", propOrder={"roleId", "roleNameAndNamespace", "permissionId", "permissionNameAndNamespace"})
    public static class OutsideOfRole
    extends RolePermissionXmlDTO {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="roleId")
        @XmlJavaTypeAdapter(value=NormalizedStringAdapter.class)
        private String roleId;
        @XmlElement(name="roleName")
        @XmlJavaTypeAdapter(value=NameAndNamespacePairValidatingAdapter.class)
        private NameAndNamespacePair roleNameAndNamespace;

        public OutsideOfRole() {
        }

        public OutsideOfRole(PermissionContract permission, String roleId, boolean populateIds) {
            super(permission, populateIds);
            Role tempRole;
            if (populateIds) {
                this.roleId = roleId;
            }
            if ((tempRole = KimApiServiceLocator.getRoleService().getRole(roleId)) == null) {
                throw new IllegalArgumentException("Cannot find role with ID \"" + roleId + "\"");
            }
            this.roleNameAndNamespace = new NameAndNamespacePair(tempRole.getNamespaceCode(), tempRole.getName());
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public NameAndNamespacePair getRoleNameAndNamespace() {
            return this.roleNameAndNamespace;
        }

        public void setRoleNameAndNamespace(NameAndNamespacePair roleNameAndNamespace) {
            this.roleNameAndNamespace = roleNameAndNamespace;
        }

        public String getRoleName() {
            return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getName() : null;
        }

        public String getRoleNamespaceCode() {
            return this.roleNameAndNamespace != null ? this.roleNameAndNamespace.getNamespaceCode() : null;
        }
    }
}

