/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.util.jaxb.NameAndNamespacePair;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.jaxb.RoleMemberXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RolePermissionXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlDTO;

public final class RoleXmlUtil {
    private RoleXmlUtil() {
    }

    static String validateAndPersistNewRole(RoleXmlDTO newRole) throws UnmarshalException {
        if (newRole == null) {
            throw new IllegalArgumentException("Cannot persist a null role");
        }
        RoleXmlUtil.validateAndPrepareRole(newRole);
        Role.Builder builder = Role.Builder.create();
        builder.setActive(newRole.getActive().booleanValue());
        builder.setDescription(newRole.getRoleDescription());
        builder.setId(newRole.getRoleId());
        builder.setKimTypeId(newRole.getKimTypeId());
        builder.setName(newRole.getRoleName());
        builder.setNamespaceCode(newRole.getNamespaceCode());
        Role role = KimApiServiceLocator.getRoleService().createRole(builder.build());
        newRole.setAlreadyPersisted(true);
        return role.getId();
    }

    static String validateAndPersistNewRoleMember(RoleMemberXmlDTO newRoleMember) throws UnmarshalException {
        if (newRoleMember == null) {
            throw new IllegalArgumentException("Cannot persist a null role member");
        }
        RoleXmlUtil.validateRoleIdAndRoleNameForMember(newRoleMember);
        RoleXmlUtil.validateMemberIdentity(newRoleMember);
        if (newRoleMember.getActiveFromDate() != null && newRoleMember.getActiveToDate() != null && newRoleMember.getActiveFromDate().compareTo((ReadableInstant)newRoleMember.getActiveToDate()) > 0) {
            throw new UnmarshalException("Cannot create a role member whose activeFromDate occurs after its activeToDate");
        }
        if (newRoleMember.getQualifications() == null) {
            newRoleMember.setQualifications(new HashMap<String, String>());
        }
        RoleMember.Builder builder = RoleMember.Builder.create((String)newRoleMember.getRoleId(), (String)newRoleMember.getRoleIdAsMember(), (String)newRoleMember.getMemberId(), (MemberType)newRoleMember.getMemberType(), (DateTime)(newRoleMember.getActiveFromDate() == null ? null : new DateTime(newRoleMember.getActiveFromDate().getMillis())), (DateTime)(newRoleMember.getActiveToDate() == null ? null : new DateTime(newRoleMember.getActiveToDate().getMillis())), newRoleMember.getQualifications(), (String)newRoleMember.getMemberName(), (String)newRoleMember.getMemberNamespaceCode());
        RoleMember newMember = KimApiServiceLocator.getRoleService().createRoleMember(builder.build());
        return newMember.getId();
    }

    static void validateAndPersistNewRolePermission(RolePermissionXmlDTO newRolePermission) throws UnmarshalException {
        if (newRolePermission == null) {
            throw new IllegalArgumentException("newRolePermission cannot be null");
        }
        RoleXmlUtil.validateAndPrepareRolePermission(newRolePermission);
        KimApiServiceLocator.getRoleService().assignPermissionToRole(newRolePermission.getPermissionId(), newRolePermission.getRoleId());
    }

    static void removeRoleMembers(String roleId, Set<String> existingRoleMemberIds) {
        if (StringUtils.isBlank((String)roleId)) {
            throw new IllegalArgumentException("roleId cannot be blank");
        }
        if (existingRoleMemberIds == null) {
            throw new IllegalArgumentException("existingRoleMemberIds cannot be null");
        }
        RoleService roleUpdateService = KimApiServiceLocator.getRoleService();
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        if (role == null) {
            throw new IllegalArgumentException("Cannot remove role members for role with ID \"" + roleId + "\" because that role does not exist");
        }
        List roleMembers = KimApiServiceLocator.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"roleId", (Object)roleId)})).getResults();
        if (roleMembers != null && !roleMembers.isEmpty()) {
            for (RoleMemberContract roleMember : roleMembers) {
                if (existingRoleMemberIds.contains(roleMember.getId())) continue;
                MemberType memberType = roleMember.getType();
                if (MemberType.PRINCIPAL.equals((Object)memberType)) {
                    roleUpdateService.removePrincipalFromRole(roleMember.getMemberId(), role.getNamespaceCode(), role.getName(), roleMember.getAttributes() != null ? roleMember.getAttributes() : new HashMap());
                    continue;
                }
                if (MemberType.GROUP.equals((Object)memberType)) {
                    roleUpdateService.removeGroupFromRole(roleMember.getMemberId(), role.getNamespaceCode(), role.getName(), roleMember.getAttributes() != null ? roleMember.getAttributes() : new HashMap());
                    continue;
                }
                if (!MemberType.ROLE.equals((Object)memberType)) continue;
                roleUpdateService.removeRoleFromRole(roleMember.getMemberId(), role.getNamespaceCode(), role.getName(), roleMember.getAttributes() != null ? roleMember.getAttributes() : new HashMap());
            }
        }
    }

    private static void validateAndPrepareRole(RoleXmlDTO newRole) throws UnmarshalException {
        if (StringUtils.isBlank((String)newRole.getRoleName()) || StringUtils.isBlank((String)newRole.getNamespaceCode())) {
            throw new UnmarshalException("Cannot create or override a role with a blank name or a blank namespace");
        }
        if (StringUtils.isBlank((String)newRole.getKimTypeId())) {
            throw new UnmarshalException("Cannot create or override a role without specikfying a KIM type");
        }
        if (StringUtils.isBlank((String)newRole.getRoleDescription())) {
            throw new UnmarshalException("Cannot create or override a role with a blank description");
        }
        String matchingId = KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName(newRole.getNamespaceCode(), newRole.getRoleName());
        if (StringUtils.isNotBlank((String)matchingId)) {
            newRole.setRoleId(matchingId);
        }
    }

    private static void validateRoleIdAndRoleNameForMember(RoleMemberXmlDTO newRoleMember) throws UnmarshalException {
        if (newRoleMember instanceof RoleMemberXmlDTO.OutsideOfRole) {
            RoleMemberXmlDTO.OutsideOfRole standaloneMember = (RoleMemberXmlDTO.OutsideOfRole)newRoleMember;
            if (standaloneMember.getRoleNameAndNamespace() != null) {
                String existingId = KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName(standaloneMember.getRoleNamespaceCode(), standaloneMember.getRoleName());
                if (StringUtils.isBlank((String)existingId)) {
                    throw new UnmarshalException("Cannot create role member for role with name \"" + standaloneMember.getRoleName() + "\" and namespace \"" + standaloneMember.getRoleNamespaceCode() + "\" because such a role does not exist");
                }
                if (StringUtils.isBlank((String)standaloneMember.getRoleId())) {
                    standaloneMember.setRoleId(existingId);
                } else if (!standaloneMember.getRoleId().equals(existingId)) {
                    throw new UnmarshalException("Cannot create role member for role with ID \"" + standaloneMember.getRoleId() + "\", name \"" + standaloneMember.getRoleName() + "\", and namespace \"" + standaloneMember.getRoleNamespaceCode() + "\" because the existing role with the same name and namespace has an ID of \"" + existingId + "\" instead");
                }
            } else {
                if (StringUtils.isBlank((String)standaloneMember.getRoleId())) {
                    throw new UnmarshalException("Cannot create role member without providing the role ID or role name + namespace that the member belongs to");
                }
                if (KimApiServiceLocator.getRoleService().getRole(standaloneMember.getRoleId()) == null) {
                    throw new UnmarshalException("Cannot create role member for the role with ID \"" + standaloneMember.getRoleId() + "\" because that role does not exist");
                }
            }
        }
        if (StringUtils.isBlank((String)newRoleMember.getRoleId())) {
            throw new UnmarshalException("Cannot create role member without providing the role ID or role name + namespace that the member belongs to");
        }
    }

    private static void validateMemberIdentity(RoleMemberXmlDTO newRoleMember) throws UnmarshalException {
        MemberType memberType = newRoleMember.getMemberType();
        if (memberType == null) {
            throw new UnmarshalException("Cannot create a role member with no member principal/group/role identification information specified");
        }
        if (StringUtils.isNotBlank((String)newRoleMember.getMemberId())) {
            if (MemberType.PRINCIPAL.equals((Object)memberType)) {
                if (KimApiServiceLocator.getIdentityService().getPrincipal(newRoleMember.getPrincipalId()) == null) {
                    throw new UnmarshalException("Cannot create principal role member with principal ID \"" + newRoleMember.getPrincipalId() + "\" because such a person does not exist");
                }
            } else if (MemberType.GROUP.equals((Object)memberType)) {
                if (KimApiServiceLocator.getGroupService().getGroup(newRoleMember.getGroupId()) == null) {
                    throw new UnmarshalException("Cannot create group role member with group ID \"" + newRoleMember.getGroupId() + "\" because such a group does not exist");
                }
            } else if (MemberType.ROLE.equals((Object)memberType)) {
                if (newRoleMember.getRoleId().equals(newRoleMember.getRoleIdAsMember())) {
                    throw new UnmarshalException("The role with ID \"" + newRoleMember.getRoleIdAsMember() + "\" cannot be made a member of itself");
                }
                if (KimApiServiceLocator.getRoleService().getRole(newRoleMember.getRoleIdAsMember()) == null) {
                    throw new UnmarshalException("Cannot use role with ID \"" + newRoleMember.getRoleIdAsMember() + "\" as a role member because such a role does not exist");
                }
            }
        }
        if (StringUtils.isNotBlank((String)newRoleMember.getMemberName())) {
            if (MemberType.PRINCIPAL.equals((Object)memberType)) {
                Principal tempPrincipal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(newRoleMember.getPrincipalName());
                if (tempPrincipal == null) {
                    throw new UnmarshalException("Cannot create principal role member with principal name \"" + newRoleMember.getPrincipalName() + "\" because such a person does not exist");
                }
                if (StringUtils.isBlank((String)newRoleMember.getPrincipalId())) {
                    newRoleMember.setPrincipalId(tempPrincipal.getPrincipalId());
                } else if (!newRoleMember.getPrincipalId().equals(tempPrincipal.getPrincipalId())) {
                    throw new UnmarshalException("Cannot create principal role member with principal ID \"" + newRoleMember.getPrincipalId() + "\" and principal name \"" + newRoleMember.getPrincipalName() + "\" because the principal with that name has an ID of \"" + tempPrincipal.getPrincipalId() + "\" instead");
                }
            } else if (MemberType.GROUP.equals((Object)memberType)) {
                NameAndNamespacePair groupNameAndNamespace = newRoleMember.getGroupName();
                Group tempGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNameAndNamespace.getNamespaceCode(), groupNameAndNamespace.getName());
                if (tempGroup == null) {
                    throw new UnmarshalException("Cannot create group role member with namespace \"" + groupNameAndNamespace.getNamespaceCode() + "\" and name \"" + groupNameAndNamespace.getName() + "\" because such a group does not exist");
                }
                if (StringUtils.isBlank((String)newRoleMember.getGroupId())) {
                    newRoleMember.setGroupId(tempGroup.getId());
                } else if (!newRoleMember.getGroupId().equals(tempGroup.getId())) {
                    throw new UnmarshalException("Cannot create group role member with ID \"" + newRoleMember.getGroupId() + "\", namespace \"" + groupNameAndNamespace.getNamespaceCode() + "\", and name \"" + groupNameAndNamespace.getName() + "\" because the group with that namespace and name has an ID of \"" + tempGroup.getId() + "\" instead");
                }
            } else if (MemberType.ROLE.equals((Object)memberType)) {
                NameAndNamespacePair roleNameAndNamespace = newRoleMember.getRoleNameAsMember();
                Role tempRole = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(roleNameAndNamespace.getNamespaceCode(), roleNameAndNamespace.getName());
                if (tempRole == null) {
                    throw new UnmarshalException("Cannot use role with namespace \"" + roleNameAndNamespace.getNamespaceCode() + "\" and name \"" + roleNameAndNamespace.getName() + "\" as a role member because such a role does not exist");
                }
                if (newRoleMember.getRoleId().equals(tempRole.getId())) {
                    throw new UnmarshalException("The role with namespace \"" + roleNameAndNamespace.getNamespaceCode() + "\" and name \"" + roleNameAndNamespace.getName() + "\" cannot be made a member of itself");
                }
                if (StringUtils.isBlank((String)newRoleMember.getRoleId())) {
                    newRoleMember.setRoleIdAsMember(tempRole.getId());
                } else if (!newRoleMember.getRoleId().equals(tempRole.getId())) {
                    throw new RuntimeException("Cannot use role with ID \"" + newRoleMember.getRoleId() + "\", namespace \"" + roleNameAndNamespace.getNamespaceCode() + "\", and name \"" + roleNameAndNamespace.getName() + "\" as a role member because the role with that namespace and name has an ID of \"" + tempRole.getId() + "\" instead");
                }
            }
        }
        if (StringUtils.isBlank((String)newRoleMember.getMemberId())) {
            throw new RuntimeException("Cannot create a role member with no member principal/group/role identification information specified");
        }
    }

    private static void validateAndPrepareRolePermission(RolePermissionXmlDTO newRolePermission) throws UnmarshalException {
        if (newRolePermission instanceof RolePermissionXmlDTO.OutsideOfRole) {
            RolePermissionXmlDTO.OutsideOfRole standaloneRolePerm = (RolePermissionXmlDTO.OutsideOfRole)newRolePermission;
            if (standaloneRolePerm.getRoleNameAndNamespace() != null) {
                String tempRoleId = KimApiServiceLocator.getRoleService().getRoleIdByNamespaceCodeAndName(standaloneRolePerm.getRoleNamespaceCode(), standaloneRolePerm.getRoleName());
                if (StringUtils.isBlank((String)tempRoleId)) {
                    throw new UnmarshalException("Cannot assign permission to role with namespace \"" + standaloneRolePerm.getRoleNamespaceCode() + "\" and name \"" + standaloneRolePerm.getRoleName() + "\" because that role does not exist");
                }
                if (StringUtils.isBlank((String)standaloneRolePerm.getRoleId())) {
                    standaloneRolePerm.setRoleId(standaloneRolePerm.getRoleId());
                } else if (!standaloneRolePerm.getRoleId().equals(tempRoleId)) {
                    throw new UnmarshalException("Cannot assign permission to role with ID \"" + standaloneRolePerm.getRoleId() + "\", namespace \"" + standaloneRolePerm.getRoleNamespaceCode() + "\", and name \"" + standaloneRolePerm.getRoleName() + "\" because the existing role with that name and namespace has an ID of \"" + tempRoleId + "\" instead");
                }
            } else {
                if (StringUtils.isBlank((String)standaloneRolePerm.getRoleId())) {
                    throw new UnmarshalException("Cannot assign permission to role without providing the role ID or role name + namespace that the permission is assigned to");
                }
                if (KimApiServiceLocator.getRoleService().getRole(standaloneRolePerm.getRoleId()) == null) {
                    throw new UnmarshalException("Cannot assign permission to role with ID \"" + standaloneRolePerm.getRoleId() + "\" because that role does not exist");
                }
            }
        }
        if (StringUtils.isBlank((String)newRolePermission.getRoleId())) {
            throw new UnmarshalException("Cannot assign permission to role without providing the role ID or role name + namespace that the permission is assigned to");
        }
        if (newRolePermission.getPermissionNameAndNamespace() != null) {
            Permission permission = KimApiServiceLocator.getPermissionService().findPermByNamespaceCodeAndName(newRolePermission.getPermissionNamespaceCode(), newRolePermission.getPermissionName());
            if (permission == null) {
                throw new UnmarshalException("Cannot get role assigned to permission with namespace \"" + newRolePermission.getPermissionNamespaceCode() + "\" and name \"" + newRolePermission.getPermissionName() + "\" because that permission does not exist");
            }
            if (StringUtils.isBlank((String)newRolePermission.getPermissionId())) {
                newRolePermission.setPermissionId(permission.getId());
            } else if (!newRolePermission.getPermissionId().equals(permission.getId())) {
                throw new UnmarshalException("Cannot get role assigned to permission with ID \"" + newRolePermission.getPermissionId() + "\", namespace \"" + newRolePermission.getPermissionNamespaceCode() + "\", and name \"" + newRolePermission.getPermissionName() + "\" because the existing permission with that name and namespace has an ID of \"" + permission.getId() + "\" instead");
            }
        } else {
            if (StringUtils.isBlank((String)newRolePermission.getPermissionId())) {
                throw new UnmarshalException("Cannot assign permission to role without specifying the ID or name and namespace of the permission to assign");
            }
            if (KimApiServiceLocator.getPermissionService().getPermission(newRolePermission.getPermissionId()) == null) {
                throw new UnmarshalException("Cannot get role assigned to permission with ID \"" + newRolePermission.getPermissionId() + "\" because that permission does not exist");
            }
        }
    }
}

