/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.jaxb;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.util.jaxb.RiceXmlExportList;
import org.kuali.rice.core.util.jaxb.RiceXmlImportList;
import org.kuali.rice.core.util.jaxb.RiceXmlListAdditionListener;
import org.kuali.rice.core.util.jaxb.RiceXmlListGetterListener;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.impl.jaxb.RoleMembersXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RolePermissionsXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlDTO;
import org.kuali.rice.kim.impl.jaxb.RoleXmlUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RolesType", propOrder={"roles"})
public class RolesXmlDTO
implements RiceXmlListAdditionListener<RoleXmlDTO>,
RiceXmlListGetterListener<RoleXmlDTO, Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="role")
    private List<RoleXmlDTO> roles;

    public RolesXmlDTO() {
    }

    public RolesXmlDTO(List<? extends Object> rolesToExport) {
        this.roles = new RiceXmlExportList<RoleXmlDTO, Object>(rolesToExport, this);
    }

    public List<RoleXmlDTO> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleXmlDTO> roles) {
        this.roles = roles;
    }

    void beforeUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.roles = new RiceXmlImportList<RoleXmlDTO>(this);
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.roles = null;
    }

    @Override
    public void newItemAdded(RoleXmlDTO item) {
        Set<String> existingRoleMemberIds;
        if (!item.isAlreadyPersisted()) {
            try {
                RoleXmlUtil.validateAndPersistNewRole(item);
            }
            catch (UnmarshalException e) {
                throw new RuntimeException(e);
            }
        }
        if ((existingRoleMemberIds = item.getExistingRoleMemberIds()) != null) {
            RoleXmlUtil.removeRoleMembers(item.getRoleId(), existingRoleMemberIds);
        }
        item.setExistingRoleMemberIds(null);
    }

    void afterMarshal(Marshaller marshaller) {
        this.roles = null;
    }

    @Override
    public RoleXmlDTO gettingNextItem(Object nextItem, int index) {
        if (!(nextItem instanceof RoleContract)) {
            throw new IllegalStateException("Object for exportation should have been a role");
        }
        RoleContract role = (RoleContract)nextItem;
        return new RoleXmlDTO(role, new RoleMembersXmlDTO.WithinRole(role.getId()), new RolePermissionsXmlDTO.WithinRole(role.getId()));
    }
}

