/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetResponseBufferSizeFilter
implements Filter {
    private Log log;
    private int bufferSize;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log = LogFactory.getLog(SetResponseBufferSizeFilter.class);
        String bufferSizeParam = filterConfig.getInitParameter("bufferSize");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("bufferSizeParam=" + bufferSizeParam));
        }
        if (bufferSizeParam == null) {
            throw new ServletException("bufferSize parameter is required");
        }
        try {
            this.bufferSize = Integer.parseInt(bufferSizeParam);
        }
        catch (NumberFormatException e) {
            throw new ServletException("bufferSize parameter is not an integer", (Throwable)e);
        }
        this.log.info((Object)("Filter initialized. Response buffer size is " + this.bufferSize));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setting response buffer size to " + this.bufferSize));
        }
        servletResponse.setBufferSize(this.bufferSize);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

