/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.client.acegi;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.cas.CasProcessingFilter;
import org.kuali.rice.kim.client.acegi.KualiDistributedSessionExpiredAuthentication;
import org.kuali.rice.kim.client.acegi.KualiDistributedSessionExpiredException;
import org.kuali.rice.kim.sesn.DistributedSession;

public class KualiDistributedSessionFilter
extends CasProcessingFilter {
    private DistributedSession distributedSession;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KualiDistributedSessionExpiredAuthentication) {
            this.logger.debug((Object)"Authentication is dead in attemptAuthentication, setting authentication to null and throwing KualiDistributedSessionExpiredException");
            SecurityContextHolder.getContext().setAuthentication(null);
            throw new KualiDistributedSessionExpiredException("Session Expired");
        }
        return super.attemptAuthentication(request);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean bSesnValid = this.isSesnValid();
        if (!bSesnValid && this.getDST() != null) {
            this.logger.debug((Object)"session invalid, setting dead authentication, and pushing through to attemptAuthentication");
            SecurityContextHolder.getContext().setAuthentication((Authentication)new KualiDistributedSessionExpiredAuthentication());
            return true;
        }
        return super.requiresAuthentication(request, response);
    }

    private boolean isSesnValid() {
        String sDST = this.getDST();
        if (sDST != null) {
            if (this.distributedSession.isSesnValid(sDST)) {
                this.logger.debug((Object)"Session Valid");
                this.distributedSession.touchSesn(sDST);
                return true;
            }
            this.distributedSession.clearSesn(sDST);
        }
        this.logger.debug((Object)"Session Not Valid");
        return false;
    }

    private String getDST() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String sDST = null;
        if (authentication != null) {
            GrantedAuthority[] authorities = authentication.getAuthorities();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Granted Authority Count:" + authorities.length));
            }
            for (int i = 0; i < authorities.length; ++i) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Authority:" + authorities[i]));
                }
                if (!authorities[i].toString().startsWith(DistributedSession.getPrefix())) continue;
                sDST = authorities[0].toString();
            }
        } else {
            this.logger.debug((Object)"Authentication is NULL");
        }
        return sDST;
    }

    public void setDistributedSession(DistributedSession distributedSession) {
        this.distributedSession = distributedSession;
    }
}

