/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.config.spring;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.MetaInfResourcePathComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfConfigUtils;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.metainf.spring.MetaInfExecutableConfig;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutowiredProjectConfig.class, MetaInfExecutableConfig.class, SpringServiceConfig.class})
public class RiceXmlConfig
implements MetaInfContextsConfig {
    private static final Boolean DEFAULT_GENERATE_RELATIVE_PATHS = Boolean.TRUE;
    private static final String RELATIVE_KEY = "metainf.xml.relative";
    private static final String PREFIX = "xml";
    private static final String INGEST_FILENAME = "ingest";
    private static final String PATH_SEPARATOR = "/";
    private static final String INITIAL_XML_PATH = "initial-xml/2.3.0";
    private static final String UPGRADE_XML_PATH = "upgrades/*";
    private static final String ALL_XML_PATH = "**/*.xml";
    @Autowired
    EnvironmentService env;
    @Autowired
    Project project;
    @Autowired
    Build build;

    @Bean
    public List<MetaInfContext> metaInfContexts() {
        ArrayList metaInfContexts = Lists.newArrayList();
        ArrayList types = Lists.newArrayList((Object[])new MetaInfDataType[]{MetaInfDataType.BOOTSTRAP, MetaInfDataType.DEMO, MetaInfDataType.TEST});
        ArrayList qualifiers = Lists.newArrayList((Object[])new String[]{INITIAL_XML_PATH, UPGRADE_XML_PATH});
        for (MetaInfDataType type : types) {
            for (String qualifier : qualifiers) {
                List<MetaInfContext> contexts = this.getMetaInfContexts(MetaInfGroup.OTHER, qualifier, type);
                metaInfContexts.addAll(contexts);
            }
        }
        return ImmutableList.copyOf((Collection)metaInfContexts);
    }

    protected List<MetaInfContext> getMetaInfContexts(MetaInfGroup group, String qualifier, MetaInfDataType type) {
        ArrayList metaInfContexts = Lists.newArrayList();
        File scanDir = this.build.getOutputDir();
        String encoding = this.build.getEncoding();
        MetaInfResourcePathComparator comparator = new MetaInfResourcePathComparator();
        String includesKey = MetaInfConfigUtils.getIncludesKey((MetaInfGroup)group, (String)PREFIX);
        String excludesKey = MetaInfConfigUtils.getExcludesKey((MetaInfGroup)group, (String)PREFIX);
        Boolean relativePaths = this.env.getBoolean(RELATIVE_KEY, DEFAULT_GENERATE_RELATIVE_PATHS);
        List pathQualifiers = MetaInfUtils.getQualifiers((File)scanDir, (Project)this.project, (List)Lists.newArrayList((Object[])new String[]{qualifier}), (List)Lists.newArrayList());
        for (String pathQualifier : pathQualifiers) {
            File outputFile = MetaInfUtils.getOutputFile((Project)this.project, (Build)this.build, (Optional)Optional.of((Object)pathQualifier), (Optional)Optional.absent(), (Optional)Optional.of((Object)type), (String)INGEST_FILENAME);
            Map<MetaInfGroup, String> defaultIncludes = this.getDefaultIncludes(pathQualifier, type);
            Map<MetaInfGroup, String> defaultExcludes = this.getDefaultExcludes();
            List includes = SpringUtils.getNoneSensitiveListFromCSV((EnvironmentService)this.env, (String)includesKey, (String)defaultIncludes.get(group));
            List excludes = SpringUtils.getNoneSensitiveListFromCSV((EnvironmentService)this.env, (String)excludesKey, (String)defaultExcludes.get(group));
            MetaInfContext context = MetaInfContext.builder((File)outputFile, (String)encoding, (File)scanDir).comparator((Comparator)comparator).includes(includes).excludes(excludes).relativePaths(relativePaths.booleanValue()).build();
            metaInfContexts.add(context);
        }
        return metaInfContexts;
    }

    protected Map<MetaInfGroup, String> getDefaultIncludes(String qualifier, MetaInfDataType type) {
        EnumMap defaultIncludes = Maps.newEnumMap(MetaInfGroup.class);
        String resourcePath = ProjectUtils.getResourcePath((String)this.project.getGroupId(), (String)this.project.getArtifactId());
        ArrayList paths = Lists.newArrayList((Object[])new String[]{resourcePath, qualifier, type.name().toLowerCase(), ALL_XML_PATH});
        defaultIncludes.put(MetaInfGroup.OTHER, StringUtils.join((Iterable)paths, (String)PATH_SEPARATOR));
        return defaultIncludes;
    }

    protected Map<MetaInfGroup, String> getDefaultExcludes() {
        EnumMap defaultExcludes = Maps.newEnumMap(MetaInfGroup.class);
        defaultExcludes.put(MetaInfGroup.OTHER, "NONE");
        return defaultExcludes;
    }
}

