/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.sql.config.spring;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.MetaInfResourceLocationComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfConfigUtils;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.metainf.spring.MetaInfExecutableConfig;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutowiredProjectConfig.class, MetaInfExecutableConfig.class, SpringServiceConfig.class})
public class RiceSqlConfig
implements MetaInfContextsConfig {
    private static final Boolean DEFAULT_GENERATE_RELATIVE_PATHS = Boolean.TRUE;
    private static final String RELATIVE_KEY = "metainf.sql.relative";
    private static final String PREFIX = "sql";
    private static final String DEFAULT_VENDORS = "mysql,oracle";
    private static final String VENDORS_KEY = "metainf.db.vendors";
    private static final String PATH_SEPARATOR = "/";
    private static final String INITIAL_SQL_PATH = "initial-sql/2.3.0";
    private static final String UPGRADE_SQL_PATH = "upgrades/*";
    private static final String SCHEMA_SQL_PATH = "rice-" + MetaInfGroup.SCHEMA.name().toLowerCase() + ".sql";
    private static final String CONSTRAINTS_SQL_PATH = "rice-" + MetaInfGroup.CONSTRAINTS.name().toLowerCase() + ".sql";
    private static final String ALL_SQL_PATH = "*.sql";
    @Autowired
    EnvironmentService env;
    @Autowired
    Project project;
    @Autowired
    Build build;

    @Bean
    public List<MetaInfContext> metaInfContexts() {
        ArrayList metaInfContexts = Lists.newArrayList();
        ArrayList types = Lists.newArrayList((Object[])new MetaInfDataType[]{MetaInfDataType.BOOTSTRAP, MetaInfDataType.DEMO, MetaInfDataType.TEST});
        List vendors = SpringUtils.getNoneSensitiveListFromCSV((EnvironmentService)this.env, (String)VENDORS_KEY, (String)DEFAULT_VENDORS);
        ArrayList groups = Lists.newArrayList((Object[])new MetaInfGroup[]{MetaInfGroup.SCHEMA, MetaInfGroup.DATA, MetaInfGroup.CONSTRAINTS});
        for (MetaInfDataType type : types) {
            for (MetaInfDataLocation location : MetaInfDataLocation.values()) {
                for (String vendor : vendors) {
                    for (MetaInfGroup group : groups) {
                        List<MetaInfContext> contexts = this.getMetaInfContexts(group, INITIAL_SQL_PATH, vendor, location, type);
                        metaInfContexts.addAll(contexts);
                    }
                }
            }
        }
        for (MetaInfDataType type : types) {
            for (MetaInfDataLocation location : MetaInfDataLocation.values()) {
                for (String vendor : vendors) {
                    List<MetaInfContext> contexts = this.getMetaInfContexts(MetaInfGroup.OTHER, UPGRADE_SQL_PATH, vendor, location, type);
                    metaInfContexts.addAll(contexts);
                }
            }
        }
        return ImmutableList.copyOf((Collection)metaInfContexts);
    }

    protected List<MetaInfContext> getMetaInfContexts(MetaInfGroup group, String qualifier, String vendor, MetaInfDataLocation location, MetaInfDataType type) {
        ArrayList metaInfContexts = Lists.newArrayList();
        File scanDir = this.build.getOutputDir();
        String encoding = this.build.getEncoding();
        MetaInfResourceLocationComparator comparator = new MetaInfResourceLocationComparator();
        String includesKey = MetaInfConfigUtils.getIncludesKey((MetaInfGroup)group, (String)PREFIX) + "." + vendor;
        String excludesKey = MetaInfConfigUtils.getExcludesKey((MetaInfGroup)group, (String)PREFIX) + "." + vendor;
        Boolean relativePaths = this.env.getBoolean(RELATIVE_KEY, DEFAULT_GENERATE_RELATIVE_PATHS);
        List pathQualifiers = MetaInfUtils.getQualifiers((File)scanDir, (Project)this.project, (List)Lists.newArrayList((Object[])new String[]{qualifier}), (List)Lists.newArrayList());
        for (String pathQualifier : pathQualifiers) {
            File outputFile = MetaInfUtils.getOutputFile((Project)this.project, (Build)this.build, (Optional)Optional.of((Object)(pathQualifier + PATH_SEPARATOR + vendor)), (Optional)Optional.of((Object)location), (Optional)Optional.of((Object)type), (String)group.name().toLowerCase());
            Map<MetaInfGroup, String> defaultIncludes = this.getDefaultIncludes(pathQualifier, vendor, location, type);
            Map<MetaInfGroup, String> defaultExcludes = this.getDefaultExcludes(defaultIncludes);
            List includes = SpringUtils.getNoneSensitiveListFromCSV((EnvironmentService)this.env, (String)includesKey, (String)defaultIncludes.get(group));
            List excludes = SpringUtils.getNoneSensitiveListFromCSV((EnvironmentService)this.env, (String)excludesKey, (String)defaultExcludes.get(group));
            MetaInfContext context = MetaInfContext.builder((File)outputFile, (String)encoding, (File)scanDir).comparator((Comparator)comparator).includes(includes).excludes(excludes).relativePaths(relativePaths.booleanValue()).build();
            metaInfContexts.add(context);
        }
        return metaInfContexts;
    }

    protected Map<MetaInfGroup, String> getDefaultIncludes(String qualifier, String vendor, MetaInfDataLocation location, MetaInfDataType type) {
        EnumMap defaultIncludes = Maps.newEnumMap(MetaInfGroup.class);
        String resourcePath = ProjectUtils.getResourcePath((String)this.project.getGroupId(), (String)this.project.getArtifactId());
        ArrayList paths = Lists.newArrayList((Object[])new String[]{resourcePath, qualifier, vendor, location.name().toLowerCase(), type.name().toLowerCase()});
        String value = StringUtils.join((Iterable)paths, (String)PATH_SEPARATOR);
        defaultIncludes.put(MetaInfGroup.SCHEMA, value + PATH_SEPARATOR + SCHEMA_SQL_PATH);
        defaultIncludes.put(MetaInfGroup.DATA, value + PATH_SEPARATOR + ALL_SQL_PATH);
        defaultIncludes.put(MetaInfGroup.CONSTRAINTS, value + PATH_SEPARATOR + CONSTRAINTS_SQL_PATH);
        defaultIncludes.put(MetaInfGroup.OTHER, value + PATH_SEPARATOR + ALL_SQL_PATH);
        return defaultIncludes;
    }

    protected Map<MetaInfGroup, String> getDefaultExcludes(Map<MetaInfGroup, String> defaultIncludes) {
        EnumMap defaultExcludes = Maps.newEnumMap(MetaInfGroup.class);
        ArrayList dataExcludes = Lists.newArrayList((Object[])new String[]{defaultIncludes.get(MetaInfGroup.SCHEMA), defaultIncludes.get(MetaInfGroup.CONSTRAINTS)});
        defaultExcludes.put(MetaInfGroup.SCHEMA, "NONE");
        defaultExcludes.put(MetaInfGroup.DATA, StringUtils.join((Iterable)dataExcludes, (String)","));
        defaultExcludes.put(MetaInfGroup.CONSTRAINTS, "NONE");
        defaultExcludes.put(MetaInfGroup.OTHER, "NONE");
        return defaultExcludes;
    }
}

