/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.generators.jpa;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class JpaToDdl {
    public static void main(String[] args) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(args[0]);
        StringBuffer sb = new StringBuffer(1000);
        StringBuffer pk = new StringBuffer();
        Table tableAnnotation = clazz.getAnnotation(Table.class);
        sb.append("CREATE TABLE ").append(tableAnnotation.name().toLowerCase()).append(" (\r\n");
        JpaToDdl.getClassFields(tableAnnotation.name().toLowerCase(), clazz, sb, pk, null);
        pk.append(" )\r\n");
        sb.append(pk);
        sb.append(")\r\n");
        sb.append("/\r\n");
        System.out.println(sb.toString());
        sb.setLength(0);
        JpaToDdl.getReferences(clazz, sb);
        System.out.println(sb.toString());
    }

    private static String javaToSqlDataType(Class<? extends Object> dataType) {
        if (dataType.equals(String.class)) {
            return "VARCHAR(40)";
        }
        if (dataType.equals(Long.class) || dataType.equals(Integer.class)) {
            return "NUMBER(?,?)";
        }
        if (dataType.equals(java.util.Date.class) || dataType.equals(Date.class)) {
            return "DATE";
        }
        if (dataType.equals(Timestamp.class)) {
            return "TIMESTAMP";
        }
        return "VARCHAR(40)";
    }

    private static void getClassFields(String tableName, Class<? extends Object> clazz, StringBuffer sb, StringBuffer pk, Map<String, AttributeOverride> overrides) {
        AttributeOverride ao;
        if (overrides == null) {
            overrides = new HashMap<String, AttributeOverride>();
        }
        if (clazz.getAnnotation(AttributeOverride.class) != null && !overrides.containsKey((ao = clazz.getAnnotation(AttributeOverride.class)).name())) {
            overrides.put(ao.name(), ao);
        }
        if (clazz.getAnnotation(AttributeOverrides.class) != null) {
            for (Field field : clazz.getAnnotation(AttributeOverrides.class).value()) {
                if (!overrides.containsKey(field.name())) {
                    overrides.put(field.name(), (AttributeOverride)field);
                }
                overrides.put(field.name(), (AttributeOverride)field);
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            Id id = field.getAnnotation(Id.class);
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            sb.append("\t");
            if (field.getName().equals("objectId")) {
                sb.append("obj_id\t\tVARCHAR2(36) NOT NULL");
            } else if (field.getName().equals("versionNumber")) {
                sb.append("ver_nbr\t\tNUMBER(8,0)");
            } else {
                if (overrides.containsKey(field.getName())) {
                    sb.append(overrides.get(field.getName()).column().name().toLowerCase());
                } else {
                    sb.append(column.name().toLowerCase());
                }
                sb.append("\t\t");
                if (field.getType() == Boolean.TYPE) {
                    sb.append("VARCHAR2(1) DEFAULT 'Y'");
                } else {
                    sb.append(JpaToDdl.javaToSqlDataType(field.getType()));
                }
                if (id != null) {
                    if (pk.length() == 0) {
                        pk.append("\tCONSTRAINT " + tableName + "p1 PRIMARY KEY ( ");
                    } else {
                        pk.append(", ");
                    }
                    if (overrides.containsKey(field.getName())) {
                        pk.append(overrides.get(field.getName()).column().name().toLowerCase());
                    } else {
                        pk.append(column.name().toLowerCase());
                    }
                }
            }
            sb.append(",\r\n");
        }
        if (!clazz.equals(PersistableBusinessObject.class) && clazz.getSuperclass() != null) {
            JpaToDdl.getClassFields(tableName, clazz.getSuperclass(), sb, pk, overrides);
        }
    }

    private static void getReferences(Class<? extends Object> clazz, StringBuffer sb) {
        for (Field field : clazz.getDeclaredFields()) {
            OneToMany oneToMany;
            JoinColumns multiKey = field.getAnnotation(JoinColumns.class);
            JoinColumn singleKey = field.getAnnotation(JoinColumn.class);
            if (multiKey == null && singleKey == null) continue;
            ArrayList<JoinColumn> keys = new ArrayList<JoinColumn>();
            if (singleKey != null) {
                keys.add(singleKey);
            }
            if (multiKey != null) {
                for (JoinColumn col : multiKey.value()) {
                    keys.add(col);
                }
            }
            if ((oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            sb.append("ALTER TABLE ");
            sb.append(field.getName());
            sb.append("\" element-class-ref=\"");
            sb.append(oneToMany.targetEntity().getName());
            sb.append("\" collection-class=\"org.apache.ojb.broker.util.collections.ManageableArrayList\" auto-retrieve=\"true\" auto-update=\"object\" auto-delete=\"object\" proxy=\"true\">\r\n");
            for (JoinColumn col : keys) {
                sb.append("\t\t\t<inverse-foreignkey field-ref=\"");
                sb.append(JpaToDdl.getPropertyFromField(clazz, col.name()));
                sb.append("\" />\r\n");
            }
            sb.append("\t\t</collection-descriptor>\r\n");
        }
    }

    private static String getPropertyFromField(Class<? extends Object> clazz, String colName) {
        for (Field field : clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !column.name().equals(colName)) continue;
            return field.getName();
        }
        return "";
    }
}

