/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.generators.jpa;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class JpaToOjbMetadata {
    public static void main(String[] args) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(args[0]);
        StringBuffer sb = new StringBuffer(1000);
        Table tableAnnotation = clazz.getAnnotation(Table.class);
        sb.append("\t<class-descriptor class=\"").append(clazz.getName()).append("\" table=\"");
        sb.append(tableAnnotation.name()).append("\">\r\n");
        JpaToOjbMetadata.getClassFields(clazz, sb, null);
        JpaToOjbMetadata.getReferences(clazz, sb);
        sb.append("\t</class-descriptor>\r\n");
        System.out.println(sb.toString());
    }

    private static String javaToOjbDataType(Class<? extends Object> dataType) {
        if (dataType.equals(String.class)) {
            return "VARCHAR";
        }
        if (dataType.equals(Long.class) || dataType.equals(Integer.class)) {
            return "BIGINT";
        }
        if (dataType.equals(java.util.Date.class) || dataType.equals(Date.class)) {
            return "DATE";
        }
        if (dataType.equals(Timestamp.class)) {
            return "TIMESTAMP";
        }
        return "VARCHAR";
    }

    private static void getClassFields(Class<? extends Object> clazz, StringBuffer sb, Map<String, AttributeOverride> overrides) {
        AttributeOverride ao;
        if (overrides == null) {
            overrides = new HashMap<String, AttributeOverride>();
        }
        if (clazz.getAnnotation(AttributeOverride.class) != null && !overrides.containsKey((ao = clazz.getAnnotation(AttributeOverride.class)).name())) {
            overrides.put(ao.name(), ao);
        }
        if (clazz.getAnnotation(AttributeOverrides.class) != null) {
            for (Field field : clazz.getAnnotation(AttributeOverrides.class).value()) {
                if (!overrides.containsKey(field.name())) {
                    overrides.put(field.name(), (AttributeOverride)field);
                }
                overrides.put(field.name(), (AttributeOverride)field);
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            Id id = field.getAnnotation(Id.class);
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            sb.append("\t\t<field-descriptor name=\"");
            sb.append(field.getName());
            sb.append("\" column=\"");
            if (overrides.containsKey(field.getName())) {
                sb.append(overrides.get(field.getName()).column().name());
            } else {
                sb.append(column.name());
            }
            sb.append("\" jdbc-type=\"");
            sb.append(JpaToOjbMetadata.javaToOjbDataType(field.getType()));
            sb.append("\" ");
            if (id != null) {
                sb.append("primarykey=\"true\" ");
            }
            if (field.getName().equals("objectId")) {
                sb.append("index=\"true\" ");
            }
            if (field.getType() == Boolean.TYPE) {
                sb.append("conversion=\"org.kuali.rice.krad.util.OjbCharBooleanConversion3\" ");
            }
            if (field.getName().equals("versionNumber")) {
                sb.append("locking=\"true\" ");
            }
            sb.append("/>\r\n");
        }
        if (!clazz.equals(PersistableBusinessObject.class) && clazz.getSuperclass() != null) {
            JpaToOjbMetadata.getClassFields(clazz.getSuperclass(), sb, overrides);
        }
    }

    private static void getReferences(Class<? extends Object> clazz, StringBuffer sb) {
        for (Field field : clazz.getDeclaredFields()) {
            OneToMany oneToMany;
            ManyToOne manyToOne;
            OneToOne oneToOne;
            JoinColumns multiKey = field.getAnnotation(JoinColumns.class);
            JoinColumn singleKey = field.getAnnotation(JoinColumn.class);
            if (multiKey == null && singleKey == null) continue;
            ArrayList<JoinColumn> keys = new ArrayList<JoinColumn>();
            if (singleKey != null) {
                keys.add(singleKey);
            }
            if (multiKey != null) {
                for (JoinColumn col : multiKey.value()) {
                    keys.add(col);
                }
            }
            if ((oneToOne = field.getAnnotation(OneToOne.class)) != null) {
                sb.append("\t\t<reference-descriptor name=\"");
                sb.append(field.getName());
                sb.append("\" class-ref=\"");
                if (!oneToOne.targetEntity().getName().equals("void")) {
                    sb.append(oneToOne.targetEntity().getName());
                } else {
                    sb.append(field.getType().getName());
                }
                sb.append("\" auto-retrieve=\"true\" auto-update=\"none\" auto-delete=\"none\" proxy=\"true\">\r\n");
                for (JoinColumn col : keys) {
                    sb.append("\t\t\t<foreignkey field-ref=\"");
                    sb.append(JpaToOjbMetadata.getPropertyFromField(clazz, col.name()));
                    sb.append("\" />\r\n");
                }
                sb.append("\t\t</reference-descriptor>\r\n");
            }
            if ((manyToOne = field.getAnnotation(ManyToOne.class)) != null) {
                sb.append("\t\t<reference-descriptor name=\"");
                sb.append(field.getName());
                sb.append("\" class-ref=\"");
                if (!manyToOne.targetEntity().getName().equals("void")) {
                    sb.append(manyToOne.targetEntity().getName());
                } else {
                    sb.append(field.getType().getName());
                }
                sb.append("\" auto-retrieve=\"true\" auto-update=\"none\" auto-delete=\"none\" proxy=\"true\">\r\n");
                for (JoinColumn col : keys) {
                    sb.append("\t\t\t<foreignkey field-ref=\"");
                    sb.append(JpaToOjbMetadata.getPropertyFromField(clazz, col.name()));
                    sb.append("\" />\r\n");
                }
                sb.append("\t\t</reference-descriptor>\r\n");
            }
            if ((oneToMany = field.getAnnotation(OneToMany.class)) == null) continue;
            sb.append("\t\t<collection-descriptor name=\"");
            sb.append(field.getName());
            sb.append("\" element-class-ref=\"");
            sb.append(oneToMany.targetEntity().getName());
            sb.append("\" collection-class=\"org.apache.ojb.broker.util.collections.ManageableArrayList\" auto-retrieve=\"true\" auto-update=\"object\" auto-delete=\"object\" proxy=\"true\">\r\n");
            for (JoinColumn col : keys) {
                sb.append("\t\t\t<inverse-foreignkey field-ref=\"");
                sb.append(JpaToOjbMetadata.getPropertyFromField(clazz, col.name()));
                sb.append("\" />\r\n");
            }
            sb.append("\t\t</collection-descriptor>\r\n");
        }
    }

    private static String getPropertyFromField(Class<? extends Object> clazz, String colName) {
        for (Field field : clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !column.name().equals(colName)) continue;
            return field.getName();
        }
        return "";
    }
}

