/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import no.geosoft.cc.io.FileListener;
import no.geosoft.cc.io.FileMonitor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.URLMonitor;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.util.UifBeanFactoryPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ReloadingDataDictionary
extends DataDictionary
implements FileListener,
URLMonitor.URLContentChangedListener,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(DataDictionary.class);
    private static final String CLASS_DIR_CONFIG_PARM = "reload.data.dictionary.classes.dir";
    private static final String SOURCE_DIR_CONFIG_PARM = "reload.data.dictionary.source.dir";
    private static final String INTERVAL_CONFIG_PARM = "reload.data.dictionary.interval";
    private URLMonitor dictionaryUrlMonitor;

    public void parseDataDictionaryConfigurationFiles(boolean allowConcurrentValidation) {
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        String classesDir = configurationService.getPropertyValueAsString(CLASS_DIR_CONFIG_PARM);
        String sourceDir = configurationService.getPropertyValueAsString(SOURCE_DIR_CONFIG_PARM);
        int reloadInterval = Integer.parseInt(configurationService.getPropertyValueAsString(INTERVAL_CONFIG_PARM));
        FileMonitor dictionaryFileMonitor = new FileMonitor((long)reloadInterval);
        this.dictionaryUrlMonitor = new URLMonitor(reloadInterval);
        this.dictionaryUrlMonitor.addListener(this);
        ArrayList configLocations = new ArrayList(this.configFileLocations);
        super.parseDataDictionaryConfigurationFiles(allowConcurrentValidation);
        for (String configLocation : configLocations) {
            Resource classFileResource = this.getFileResource(configLocation);
            try {
                if (classFileResource.getURI().toString().startsWith("jar:")) {
                    LOG.debug((Object)("Monitoring dictionary file at URI: " + classFileResource.getURI().toString()));
                    this.dictionaryUrlMonitor.addURI(classFileResource.getURL());
                    continue;
                }
                String filePathClassesDir = classFileResource.getFile().getAbsolutePath();
                String sourceFilePath = StringUtils.replace((String)filePathClassesDir, (String)classesDir, (String)sourceDir);
                File dictionaryFile = new File(filePathClassesDir);
                if (!dictionaryFile.exists()) continue;
                LOG.debug((Object)("Monitoring dictionary file: " + dictionaryFile.getName()));
                dictionaryFileMonitor.addFile(dictionaryFile);
            }
            catch (Exception e) {
                LOG.info((Object)("Exception in picking up dictionary file for monitoring:  " + e.getMessage()), (Throwable)e);
            }
        }
        dictionaryFileMonitor.addListener((FileListener)this);
    }

    public void fileChanged(File file) {
        LOG.info((Object)("reloading dictionary configuration for " + file.getName()));
        try {
            FileSystemResource resource = new FileSystemResource(file);
            this.xmlReader.loadBeanDefinitions((Resource)resource);
            UifBeanFactoryPostProcessor factoryPostProcessor = new UifBeanFactoryPostProcessor();
            factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)this.ddBeans);
            this.ddIndex.run();
        }
        catch (Exception e) {
            LOG.info((Object)("Exception in dictionary hot deploy: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void urlContentChanged(URL url) {
        LOG.info((Object)("reloading dictionary configuration for " + url.toString()));
        try {
            InputStream urlStream = url.openStream();
            InputStreamResource resource = new InputStreamResource(urlStream);
            int originalValidationMode = this.xmlReader.getValidationMode();
            this.xmlReader.setValidationMode(3);
            this.xmlReader.loadBeanDefinitions((Resource)resource);
            this.xmlReader.setValidationMode(originalValidationMode);
            UifBeanFactoryPostProcessor factoryPostProcessor = new UifBeanFactoryPostProcessor();
            factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)this.ddBeans);
            this.ddIndex.run();
        }
        catch (Exception e) {
            LOG.info((Object)("Exception in dictionary hot deploy: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
            context.addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent e) {
                    LOG.info((Object)("Context '" + e.getApplicationContext().getDisplayName() + "' closed, shutting down URLMonitor scheduler"));
                    ReloadingDataDictionary.this.dictionaryUrlMonitor.shutdownScheduler();
                }
            });
        }
    }
}

