/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintainablexml;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.maintainablexml.FileConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertMaintainableXML {
    private static final String MAINTAINABLE_CONVERSION_CONFIG_FILE = "maintainable.conversion.rule.file";

    public static void main(String[] args) {
        String filePath;
        File file;
        String settingsFile = "";
        if (StringUtils.isEmpty((String)settingsFile)) {
            settingsFile = ConvertMaintainableXML.readInput("Enter config file location relative to Kuali main user directory (ie. dev/sample-app-config.xml OR MaintainableXMLConversionConfig.xml) : ", null, false);
        }
        if (!(file = new File(filePath = System.getProperty("user.home") + "/" + settingsFile)).exists()) {
            System.out.println("The settings file location is not valid : \n" + filePath);
            System.exit(1);
        }
        try {
            String fromRange;
            HashMap settingsMap = ConvertMaintainableXML.getSettings(filePath);
            System.out.println("Using the following settings : " + settingsMap + "\n");
            String runMode = (String)settingsMap.get("runMode");
            if (StringUtils.isEmpty((String)runMode) || !StringUtils.equals((String)runMode, (String)"1") && !StringUtils.equals((String)runMode, (String)"2")) {
                runMode = ConvertMaintainableXML.readInput("Run mode :\n1. Update xml in DB\n2. Print old and new xml\nEnter 1 or 2\n", new String[]{"1", "2"}, false);
            }
            if (StringUtils.isEmpty((String)(fromRange = (String)settingsMap.get("fromRange"))) || !StringUtils.equals((String)fromRange, (String)"all") && !ConvertMaintainableXML.isNumber(fromRange)) {
                fromRange = ConvertMaintainableXML.readInput("Please enter document start range value ('all', empty line for all, or the starting document number such as 1000) :\n", new String[]{"all", ""}, true);
            }
            String toRange = null;
            boolean hasRangeParameters = false;
            if (!"".equals(fromRange) && !"all".equals(fromRange)) {
                toRange = (String)settingsMap.get("toRange");
                if (StringUtils.isEmpty((String)toRange) || !ConvertMaintainableXML.isNumber(toRange)) {
                    toRange = ConvertMaintainableXML.readInput("Please enter end range value :\n", null, true);
                }
                System.out.println("Upgrading document numbers from " + fromRange + " to " + toRange + "\n");
                hasRangeParameters = true;
            }
            FileConverter fileConverter = new FileConverter();
            fileConverter.runFileConversion(settingsMap, runMode, fromRange, toRange, hasRangeParameters);
        }
        catch (Exception e) {
            System.out.println("Error executing conversion : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String readInput(String message, String[] validOptions, boolean numeric) {
        System.out.print(message);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String inputString = null;
        try {
            inputString = br.readLine();
            if (numeric && (validOptions == null || !Arrays.asList(validOptions).contains(inputString))) {
                Integer.parseInt(inputString);
                return inputString;
            }
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read input!");
            System.exit(1);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Invalid Option! Must be numeric.");
            ConvertMaintainableXML.readInput(message, validOptions, numeric);
        }
        if (validOptions != null && !Arrays.asList(validOptions).contains(inputString)) {
            System.out.println("Invalid Option!");
            ConvertMaintainableXML.readInput(message, validOptions, numeric);
        }
        return inputString;
    }

    public static HashMap getSettings(String filePath) throws Exception {
        File file = new File(filePath);
        HashMap<String, String> params = new HashMap<String, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(file);
        doc.getDocumentElement().normalize();
        NodeList nodeLst = doc.getElementsByTagName("param");
        for (int s = 0; s < nodeLst.getLength(); ++s) {
            Node fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() != 1) continue;
            Element fstElmnt = (Element)fstNode;
            String paramName = fstElmnt.getAttribute("name");
            NodeList textFNList = fstElmnt.getChildNodes();
            if (textFNList.item(0) != null) {
                String paramValue = textFNList.item(0).getNodeValue().trim();
                params.put(paramName, paramValue);
                continue;
            }
            params.put(paramName, null);
        }
        return params;
    }
}

