/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintainablexml;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.kuali.rice.krad.maintainablexml.EncryptionService;
import org.kuali.rice.krad.maintainablexml.MaintainableXMLConversionServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class FileConverter {
    private JdbcTemplate jdbcTemplate;
    private int totalDocs = 0;

    public void runFileConversion(HashMap settingsMap, final String runMode, final String fromRange, final String toRange, final boolean hasRangeParameters) throws Exception {
        final EncryptionService encryptService = new EncryptionService((String)settingsMap.get("encryption.key"));
        String docSQL = "SELECT DOC_HDR_ID, DOC_CNTNT FROM krns_maint_doc_t ";
        if (hasRangeParameters) {
            docSQL = docSQL.concat(" WHERE DOC_HDR_ID >= '" + fromRange + "' AND DOC_HDR_ID <= '" + toRange + "'");
        }
        System.out.println("SQL to run:" + docSQL);
        this.jdbcTemplate = new JdbcTemplate(FileConverter.getDataSource(settingsMap));
        this.jdbcTemplate.query(docSQL, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                if (hasRangeParameters) {
                    int docId = Integer.parseInt(rs.getString(1));
                    if (docId >= Integer.parseInt(fromRange) && docId <= Integer.parseInt(toRange)) {
                        FileConverter.this.processDocumentRow(rs.getString(1), rs.getString(2), encryptService, runMode);
                    }
                } else {
                    FileConverter.this.processDocumentRow(rs.getString(1), rs.getString(2), encryptService, runMode);
                }
            }
        });
        System.out.println(this.totalDocs + " maintenance documents upgraded.");
    }

    public static DataSource getDataSource(HashMap settingsMap) {
        String driver = "";
        driver = "MySQL".equals(settingsMap.get("datasource.ojb.platform")) ? "com.mysql.jdbc.Driver" : ("Oracle9i".equals(settingsMap.get("datasource.ojb.platform")) ? "oracle.jdbc.driver.OracleDriver" : (String)settingsMap.get("datasource.driver.name"));
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl((String)settingsMap.get("datasource.url"));
        dataSource.setUsername((String)settingsMap.get("datasource.username"));
        dataSource.setPassword((String)settingsMap.get("datasource.password"));
        return dataSource;
    }

    public void processDocumentRow(String docId, String docCntnt, EncryptionService encryptServ, String runMode) {
        System.out.println(docId);
        try {
            String oldXml = docCntnt;
            if (encryptServ.isEnabled()) {
                oldXml = encryptServ.decrypt(docCntnt);
            }
            if ("2".equals(runMode)) {
                System.out.println("------ ORIGINAL DOC XML --------");
                System.out.println(oldXml);
                System.out.println("--------------------------------");
            }
            MaintainableXMLConversionServiceImpl maintainableXMLConversionServiceImpl = new MaintainableXMLConversionServiceImpl();
            String newXML = maintainableXMLConversionServiceImpl.transformMaintainableXML(oldXml);
            if ("2".equals(runMode)) {
                System.out.println("******* UPGRADED DOC XML ********");
                System.out.println(newXML);
                System.out.println("*********************************\n");
            }
            if ("1".equals(runMode)) {
                if (encryptServ.isEnabled()) {
                    this.jdbcTemplate.update("update krns_maint_doc_t set DOC_CNTNT = ? where DOC_HDR_ID = ?", new Object[]{encryptServ.encrypt(newXML), docId});
                } else {
                    this.jdbcTemplate.update("update krns_maint_doc_t set DOC_CNTNT = ? where DOC_HDR_ID = ?", new Object[]{newXML, docId});
                }
            }
            ++this.totalDocs;
        }
        catch (Exception ex) {
            Logger.getLogger(FileConverter.class.getName()).log(Level.SEVERE, null, ex);
            System.exit(1);
        }
    }
}

