/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.apache.log4j.Logger;

public class MemoryMonitor {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static final Logger LOG = Logger.getLogger(MemoryMonitor.class);
    private String springContextId;
    private static final MemoryPoolMXBean tenuredGenPool = MemoryMonitor.findTenuredGenPool();

    public MemoryMonitor() {
        LOG.info((Object)"initializing");
        this.springContextId = "Unknown";
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    long maxMemory = tenuredGenPool.getUsage().getMax();
                    long usedMemory = tenuredGenPool.getUsage().getUsed();
                    for (Listener listener : MemoryMonitor.this.listeners) {
                        listener.memoryUsageLow(MemoryMonitor.this.springContextId, usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    public MemoryMonitor(String springContextId) {
        this();
        this.springContextId = springContextId;
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("percentage not in range");
        }
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"could not find tenured space");
    }

    public static interface Listener {
        public void memoryUsageLow(String var1, long var2, long var4);
    }
}

