/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util.spring;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodLoggingInterceptor
implements MethodInterceptor {
    private static final Log LOG = LogFactory.getLog(MethodLoggingInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object methodResult = null;
        String invocationLabel = this.buildInvocationLabel(invocation);
        try {
            LOG.fatal((Object)("entering " + invocationLabel));
            methodResult = invocation.proceed();
        }
        catch (Exception invocationException) {
            String exceptionLabel = this.buildExceptionLabel(invocationException);
            LOG.fatal((Object)("aborting " + invocationLabel + ": throwing " + exceptionLabel));
            throw invocationException;
        }
        LOG.fatal((Object)new StringBuffer("leaving  ").append(invocationLabel).append(" / took ").append(System.currentTimeMillis() - startTime).append(" ms"));
        return methodResult;
    }

    private String buildInvocationLabel(MethodInvocation invocation) {
        Class<?> declaringClass;
        StringBuffer invocationLabel = new StringBuffer();
        Method method = invocation.getMethod();
        Class<?> targetClass = invocation.getThis().getClass();
        if (targetClass != (declaringClass = method.getDeclaringClass())) {
            invocationLabel.append("{");
            invocationLabel.append(declaringClass.getName());
            invocationLabel.append("} ");
        }
        invocationLabel.append(targetClass.getName() + "." + method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] argValues = invocation.getArguments();
        invocationLabel.append("(");
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    invocationLabel.append(",");
                }
                invocationLabel.append(paramTypes[i].getName());
                invocationLabel.append("=");
                if (argValues[i] == null) {
                    invocationLabel.append("<literal null>");
                    continue;
                }
                invocationLabel.append(argValues[i]);
            }
        }
        invocationLabel.append(")");
        return invocationLabel.toString();
    }

    private String buildExceptionLabel(Exception e) {
        String className = e.getClass().getName();
        String exceptionLabel = StringUtils.substringAfterLast((String)className, (String)".");
        if (StringUtils.isBlank((String)exceptionLabel)) {
            exceptionLabel = className;
        }
        return exceptionLabel;
    }
}

