/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public abstract class AbstractJoinColumnResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(AbstractJoinColumnResolver.class);

    public AbstractJoinColumnResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    protected final List<Expression> getJoinColumns(String enclosingClass, String fieldName, String mappedClass) {
        ObjectReferenceDescriptor ord = OjbUtil.findObjectReferenceDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        CollectionDescriptor cld = OjbUtil.findCollectionDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (ord != null) {
            return this.processReferenceField(enclosingClass, fieldName, mappedClass, ord);
        }
        if (cld != null) {
            return this.processCollectionField(enclosingClass, fieldName, mappedClass, cld);
        }
        return Collections.emptyList();
    }

    private List<Expression> processReferenceField(String enclosingClass, String fieldName, String mappedClass, ObjectReferenceDescriptor ord) {
        ArrayList<Expression> joinColumns = new ArrayList<Expression>();
        Vector fks = ord.getForeignKeyFields();
        if (fks == null || fks.isEmpty()) {
            LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not have any foreign keys configured");
            return joinColumns;
        }
        Collection<String> pks = OjbUtil.getPrimaryKeyNames(mappedClass, this.descriptorRepositories);
        if (!(pks.containsAll(fks) && fks.containsAll(pks) || pks.isEmpty())) {
            FieldDescriptor[] pkDescs;
            ClassDescriptor cd = OjbUtil.findClassDescriptor(mappedClass, this.descriptorRepositories);
            ClassDescriptor icd = this.getItemClassDescriptor(enclosingClass, fieldName, mappedClass, ord);
            FieldDescriptor[] fkDescs = ord.getForeignKeyFieldDescriptors(cd);
            if (fkDescs.length != (pkDescs = icd.getPkFields()).length) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " with an foreign key that is not joined to all of the primary key fields. This is not supported in JPA.");
            }
            for (int i = 0; i < fkDescs.length; ++i) {
                joinColumns.add((Expression)this.createJoinColumn(fkDescs[i], pkDescs[i]));
            }
        }
        return joinColumns;
    }

    private List<Expression> processCollectionField(String enclosingClass, String fieldName, String mappedClass, CollectionDescriptor cld) {
        ArrayList<Expression> joinColumns = new ArrayList<Expression>();
        if (!cld.isMtoNRelation()) {
            FieldDescriptor[] pkDescs;
            Vector fks = cld.getForeignKeyFields();
            if (fks == null || fks.isEmpty()) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " but does not have any inverse foreign keys configured");
                return joinColumns;
            }
            ClassDescriptor cd = OjbUtil.findClassDescriptor(mappedClass, this.descriptorRepositories);
            ClassDescriptor icd = this.getItemClassDescriptor(enclosingClass, fieldName, mappedClass, cld);
            FieldDescriptor[] fkDescs = cld.getForeignKeyFieldDescriptors(icd);
            if (fkDescs.length != (pkDescs = cd.getPkFields()).length) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " with an inverse foreign key that is not joined to all of the primary key fields.  This is not supported in JPA.");
            }
            for (int i = 0; i < fkDescs.length; ++i) {
                joinColumns.add((Expression)this.createJoinColumn(pkDescs[i], fkDescs[i]));
            }
        }
        return joinColumns;
    }

    private AnnotationExpr createJoinColumn(FieldDescriptor thisField, FieldDescriptor itemField) {
        ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
        pairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(thisField.getColumnName())));
        pairs.add(new MemberValuePair("referencedColumnName", (Expression)new StringLiteralExpr(itemField.getColumnName())));
        if (!this.isAnonymousFk(thisField)) {
            pairs.add(new MemberValuePair("insertable", (Expression)new BooleanLiteralExpr(false)));
            pairs.add(new MemberValuePair("updatable", (Expression)new BooleanLiteralExpr(false)));
        }
        return new NormalAnnotationExpr(new NameExpr("JoinColumn"), pairs);
    }

    private ClassDescriptor getItemClassDescriptor(String enclosingClass, String fieldName, String mappedClass, CollectionDescriptor cld) {
        return this.getItemClassDescriptor(enclosingClass, fieldName, mappedClass, cld.getItemClassName());
    }

    private ClassDescriptor getItemClassDescriptor(String enclosingClass, String fieldName, String mappedClass, ObjectReferenceDescriptor ord) {
        return this.getItemClassDescriptor(enclosingClass, fieldName, mappedClass, ord.getItemClassName());
    }

    private ClassDescriptor getItemClassDescriptor(String enclosingClass, String fieldName, String mappedClass, String itemClassName) {
        if (StringUtils.isBlank((String)itemClassName)) {
            LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not class name attribute");
            return null;
        }
        return OjbUtil.findClassDescriptor(itemClassName, this.descriptorRepositories);
    }

    private boolean isAnonymousFk(FieldDescriptor fd) {
        if (fd != null) {
            return "anonymous".equals(fd.getAccess());
        }
        return false;
    }

    private boolean isNullableFk(FieldDescriptor fd) {
        if (fd != null) {
            return fd.isRequired();
        }
        return false;
    }
}

