/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public abstract class AbstractPrimaryKeyJoinColumnResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(AbstractPrimaryKeyJoinColumnResolver.class);

    public AbstractPrimaryKeyJoinColumnResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    protected final List<Expression> getJoinColumns(String enclosingClass, String fieldName, String mappedClass) {
        ObjectReferenceDescriptor ord = OjbUtil.findObjectReferenceDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        ArrayList<Expression> joinColumns = new ArrayList<Expression>();
        if (this.foundDescriptor(ord)) {
            List<String> fks = this.getForeignKeys(ord);
            if (fks == null || fks.isEmpty()) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not have any foreign keys configured");
                return null;
            }
            Collection<String> pks = OjbUtil.getPrimaryKeyNames(mappedClass, this.descriptorRepositories);
            if (pks.size() == fks.size() && pks.containsAll(fks) && !pks.isEmpty()) {
                ClassDescriptor cd = OjbUtil.findClassDescriptor(mappedClass, this.descriptorRepositories);
                String itemClassName = this.getItemClass(ord);
                if (StringUtils.isBlank((String)itemClassName)) {
                    LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not class name attribute");
                    return null;
                }
                ClassDescriptor icd = OjbUtil.findClassDescriptor(itemClassName, this.descriptorRepositories);
                FieldDescriptor[] pfds = cd.getPkFields();
                FieldDescriptor[] ipfds = icd.getPkFields();
                for (int i = 0; i < pfds.length; ++i) {
                    ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
                    pairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(pfds[i].getColumnName())));
                    pairs.add(new MemberValuePair("referencedColumnName", (Expression)new StringLiteralExpr(ipfds[i].getColumnName())));
                    joinColumns.add((Expression)new NormalAnnotationExpr(new NameExpr("PrimaryKeyJoinColumn"), pairs));
                }
                if (this.isCascadeDelete(ord)) {
                    LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor set to cascade delete but JPA does not support that configuration with primary key join columns.");
                }
                if (this.isCascadePersist(ord)) {
                    LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor set to cascade persist but JPA does not support that configuration with primary key join columns.");
                }
            }
        }
        return joinColumns;
    }

    private boolean foundDescriptor(ObjectReferenceDescriptor ord) {
        return ord != null;
    }

    private List<String> getForeignKeys(ObjectReferenceDescriptor ord) {
        if (ord != null) {
            return ord.getForeignKeyFields();
        }
        return null;
    }

    private String getItemClass(ObjectReferenceDescriptor ord) {
        if (ord != null) {
            return ord.getItemClassName();
        }
        return null;
    }

    private boolean isCascadeDelete(ObjectReferenceDescriptor ord) {
        return ord.getCascadingDelete() == 23;
    }

    private boolean isCascadePersist(ObjectReferenceDescriptor ord) {
        return ord.getCascadingStore() == 23;
    }
}

