/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class ColumnResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(ColumnResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Column";
    private final boolean upperCaseTableName;

    public ColumnResolver(Collection<DescriptorRepository> descriptorRepositories, boolean upperCaseTableName) {
        super(descriptorRepositories);
        this.upperCaseTableName = upperCaseTableName;
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Column";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null) {
            ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
            String access = fd.getAccess();
            if ("readonly".equals(access)) {
                pairs.add(new MemberValuePair("insertable", (Expression)new BooleanLiteralExpr(false)));
                pairs.add(new MemberValuePair("updatable", (Expression)new BooleanLiteralExpr(false)));
            } else if ("readwrite".equals(access)) {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field access is readwrite keeping @Column attributes (insertable, updatable) at defaults");
            } else if ("anonymous".equals(access)) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field access is anonymous, the field should not exist in the java class as is the meaning anonymous access");
            } else if (access == null) {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field access is null keeping @Column attributes (insertable, updatable) at defaults");
            } else {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field access is " + access + ", unsupported conversion to @Column attributes");
            }
            String columnName = fd.getColumnName();
            if (StringUtils.isNotBlank((String)columnName)) {
                pairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(this.upperCaseTableName ? columnName.toUpperCase() : columnName)));
            } else {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field column is blank");
            }
            boolean required = fd.isRequired();
            if (required) {
                pairs.add(new MemberValuePair("nullable", (Expression)new BooleanLiteralExpr(false)));
            } else {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field is nullable keeping @Column attribute (nullable) at default");
            }
            int length = fd.getLength();
            if (length > 0) {
                pairs.add(new MemberValuePair("length", (Expression)new IntegerLiteralExpr(String.valueOf(length))));
            } else {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field length is not set keeping @Column attribute (length) at default");
            }
            int precision = fd.getPrecision();
            if (precision > 0) {
                pairs.add(new MemberValuePair("precision", (Expression)new IntegerLiteralExpr(String.valueOf(precision))));
            } else {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field precision is not set keeping @Column attribute (precision) at default");
            }
            int scale = fd.getScale();
            if (scale > 0) {
                pairs.add(new MemberValuePair("scale", (Expression)new IntegerLiteralExpr(String.valueOf(scale))));
            } else {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field scale is not set keeping @Column attribute (scale) at default");
            }
            return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
        }
        return null;
    }
}

