/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversionDefaultImpl;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class ConvertResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(ConvertResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Convert";
    private Map<String, String> converterMappings;

    public ConvertResolver(Collection<DescriptorRepository> descriptorRepositories, Map<String, String> converterMappings) {
        super(descriptorRepositories);
        this.converterMappings = converterMappings;
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Convert";
    }

    private String getJpaConverterForOjbClass(String ojbConverter) {
        for (String key : this.converterMappings.keySet()) {
            if (!ojbConverter.contains(key)) continue;
            return this.converterMappings.get(key);
        }
        return null;
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        FieldConversion fc;
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null && (fc = fd.getFieldConversion()) != null && FieldConversionDefaultImpl.class != fc.getClass()) {
            LOG.info(enclosingClass + "." + fieldName + " for the mapped class " + mappedClass + " field has a converter " + fc.getClass().getName());
            String jpaConverter = this.getJpaConverterForOjbClass(fc.getClass().getName());
            if (jpaConverter == null) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a converter " + fc.getClass().getName() + " but a replacement converter was not configured, unable to set Convert class");
                return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("converter", (Expression)new NameExpr(null)))), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
            }
            if (StringUtils.isBlank((String)jpaConverter)) {
                LOG.info(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a converter " + fc.getClass().getName() + " But no converter definition is needed due to default converter configuration.");
            } else {
                String shortClassName = ClassUtils.getShortClassName((String)jpaConverter);
                String packageName = ClassUtils.getPackageName((String)jpaConverter);
                return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("converter", (Expression)new NameExpr(shortClassName + ".class")))), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), Collections.singletonList(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(packageName), shortClassName), false, false)));
            }
        }
        return null;
    }
}

