/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.ParserUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.Level;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class CustomizerResolver
implements AnnotationResolver {
    private static final Logger LOG = LogManager.getLogger(CustomizerResolver.class);
    public static final String PACKAGE = "org.eclipse.persistence.annotations";
    public static final String SIMPLE_NAME = "Customizer";
    private final Collection<DescriptorRepository> descriptorRepositories;

    public CustomizerResolver(Collection<DescriptorRepository> descriptorRepositories) {
        this.descriptorRepositories = descriptorRepositories;
    }

    @Override
    public String getFullyQualifiedName() {
        return "org.eclipse.persistence.annotations.Customizer";
    }

    @Override
    public Level getLevel() {
        return Level.CLASS;
    }

    @Override
    public NodeData resolve(Node node, String mappedClass) {
        if (!(node instanceof ClassOrInterfaceDeclaration)) {
            throw new IllegalArgumentException("this annotation belongs only on ClassOrInterfaceDeclaration");
        }
        TypeDeclaration dclr = (TypeDeclaration)node;
        if (!(dclr.getParentNode() instanceof CompilationUnit)) {
            return null;
        }
        String name = dclr.getName();
        String pckg = ((CompilationUnit)dclr.getParentNode()).getPackage().getName().toString();
        String enclosingClass = pckg + "." + name;
        Collection<String> customizedFieldsOnNode = this.getFieldsOnNode(dclr, this.getCustomizedFields(mappedClass));
        if (customizedFieldsOnNode == null || customizedFieldsOnNode.isEmpty()) {
            LOG.info(ResolverUtil.logMsgForClass(enclosingClass, mappedClass) + " has no customized fields");
            return null;
        }
        return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new NameExpr("CreateCustomizerFor" + customizedFieldsOnNode.toString())), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
    }

    private Collection<String> getCustomizedFields(String clazz) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, this.descriptorRepositories);
        if (cd != null) {
            ArrayList<String> customizedFields = new ArrayList<String>();
            for (CollectionDescriptor cld : cd.getCollectionDescriptors()) {
                if (cld.getQueryCustomizer() == null) continue;
                customizedFields.add(cld.getAttributeName());
            }
            return customizedFields;
        }
        return Collections.emptySet();
    }

    private Collection<String> getFieldsOnNode(TypeDeclaration node, Collection<String> fields) {
        ArrayList<String> fieldsOnNode = new ArrayList<String>();
        List<FieldDeclaration> fds = ParserUtil.getFieldMembers(node.getMembers());
        if (fields != null) {
            for (FieldDeclaration f : fds) {
                String name = ParserUtil.getFieldName(f);
                if (!fields.contains(name)) continue;
                fieldsOnNode.add(name);
            }
        }
        return fieldsOnNode;
    }
}

