/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class JoinTableResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(JoinTableResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "JoinTable";

    public JoinTableResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        CollectionDescriptor cld = OjbUtil.findCollectionDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (cld != null) {
            String itemClassName;
            ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
            ArrayList<ImportDeclaration> additionalImports = new ArrayList<ImportDeclaration>();
            if (!cld.isMtoNRelation()) {
                return null;
            }
            boolean error = false;
            String joinTable = cld.getIndirectionTable();
            if (StringUtils.isBlank((String)joinTable)) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but does not have an indirection table configured");
                error = true;
            } else {
                pairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(joinTable)));
            }
            String[] fkToItemClass = this.getFksToItemClass(cld);
            if (fkToItemClass == null || fkToItemClass.length == 0) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but does not have any fk-pointing-to-element-class configured");
                error = true;
            }
            if (StringUtils.isBlank((String)(itemClassName = cld.getItemClassName()))) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not class name attribute");
                error = true;
            }
            if (error) {
                return null;
            }
            ArrayList<NormalAnnotationExpr> joinColumns = new ArrayList<NormalAnnotationExpr>();
            for (String fk : fkToItemClass) {
                ArrayList<MemberValuePair> joinColumnsPairs = new ArrayList<MemberValuePair>();
                joinColumnsPairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(fk)));
                Collection<String> pks = OjbUtil.getPrimaryKeyNames(itemClassName, this.descriptorRepositories);
                joinColumnsPairs.add(new MemberValuePair("referencedColumnName", (Expression)new StringLiteralExpr(this.getPksAsString(pks))));
                joinColumns.add(new NormalAnnotationExpr(new NameExpr("JoinColumn"), joinColumnsPairs));
            }
            pairs.add(new MemberValuePair("joinColumns", (Expression)new ArrayInitializerExpr(joinColumns)));
            additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "JoinColumn"), false, false));
            String[] fkToThisClass = this.getFksToThisClass(cld);
            if (fkToThisClass == null || fkToThisClass.length == 0) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but does not have any fk-pointing-to-this-class configured");
                return null;
            }
            ArrayList<NormalAnnotationExpr> invJoinColumns = new ArrayList<NormalAnnotationExpr>();
            for (String fk : fkToItemClass) {
                ArrayList<MemberValuePair> invJoinColumnsPairs = new ArrayList<MemberValuePair>();
                invJoinColumnsPairs.add(new MemberValuePair("name", (Expression)new StringLiteralExpr(fk)));
                Collection<String> pks = OjbUtil.getPrimaryKeyNames(mappedClass, this.descriptorRepositories);
                invJoinColumnsPairs.add(new MemberValuePair("referencedColumnName", (Expression)new StringLiteralExpr(this.getPksAsString(pks))));
                invJoinColumns.add(new NormalAnnotationExpr(new NameExpr("JoinColumn"), invJoinColumnsPairs));
            }
            pairs.add(new MemberValuePair("inverseJoinColumns", (Expression)new ArrayInitializerExpr(invJoinColumns)));
            Vector fks = cld.getForeignKeyFields();
            if (fks != null || !fks.isEmpty()) {
                LOG.warn(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but has the inverse-foreignkey configured as opposed to " + "fk-pointing-to-this-class and fk-pointing-to-element-class");
            }
            return new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
        }
        return null;
    }

    private String getPksAsString(Collection<String> descriptors) {
        if (descriptors.size() == 1) {
            return descriptors.iterator().next();
        }
        String pks = "";
        for (String d : descriptors) {
            pks = pks + d + "|";
        }
        return pks;
    }

    private String[] getFksToItemClass(CollectionDescriptor cld) {
        try {
            return cld.getFksToItemClass();
        }
        catch (NullPointerException e) {
            return new String[0];
        }
    }

    private String[] getFksToThisClass(CollectionDescriptor cld) {
        try {
            return cld.getFksToItemClass();
        }
        catch (NullPointerException e) {
            return new String[0];
        }
    }
}

