/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class LobResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(LobResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "Lob";
    private static final Collection<Class<?>> VALID_TYPES;
    private static final Collection<String> VALID_TYPES_STR;

    public LobResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.Lob";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        FieldDescriptor fd = OjbUtil.findFieldDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (fd != null) {
            Class<?> fc = ResolverUtil.getType(enclosingClass, fieldName);
            String columnType = fd.getColumnType();
            if (this.isLob(columnType)) {
                if (this.isValidFieldType(fc)) {
                    return new NodeData((AnnotationExpr)new MarkerAnnotationExpr(new NameExpr(SIMPLE_NAME)), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false));
                }
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " is not a valid field type for the @Lob annotation, must be one of " + VALID_TYPES_STR);
            }
            return null;
        }
        return null;
    }

    private boolean isLob(String columnType) {
        return "BLOB".equals(columnType) || "CLOB".equals(columnType);
    }

    private boolean isValidFieldType(Class<?> type) {
        for (Class<?> c : VALID_TYPES) {
            if (!c.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<Class<Character[]>> tempClass = new ArrayList<Class<Character[]>>();
        tempClass.add(String.class);
        tempClass.add(byte[].class);
        tempClass.add(Byte[].class);
        tempClass.add(char[].class);
        tempClass.add(Character[].class);
        ArrayList<String> tempClassStr = new ArrayList<String>();
        for (Class clazz : tempClass) {
            tempClassStr.add(clazz.getName());
        }
        VALID_TYPES = Collections.unmodifiableCollection(tempClass);
        VALID_TYPES_STR = Collections.unmodifiableCollection(tempClassStr);
    }
}

