/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.AbstractMappedFieldResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.BidirectionalOwnerRegistry;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class ManyToManyResolver
extends AbstractMappedFieldResolver {
    private static final Logger LOG = LogManager.getLogger(ManyToManyResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "ManyToMany";

    public ManyToManyResolver(Collection<DescriptorRepository> descriptorRepositories) {
        super(descriptorRepositories);
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.ManyToMany";
    }

    @Override
    protected NodeData getAnnotationNodes(String enclosingClass, String fieldName, String mappedClass) {
        CollectionDescriptor cld = OjbUtil.findCollectionDescriptor(mappedClass, fieldName, this.descriptorRepositories);
        if (cld != null) {
            NodeData nodeData;
            int autoUpdate;
            boolean refresh;
            String itemClassName;
            String[] fkToThisClass;
            ArrayList<MemberValuePair> pairs = new ArrayList<MemberValuePair>();
            ArrayList<ImportDeclaration> additionalImports = new ArrayList<ImportDeclaration>();
            if (!cld.isMtoNRelation()) {
                return null;
            }
            boolean fkError = false;
            String[] fkToItemClass = this.getFksToItemClass(cld);
            if (fkToItemClass == null || fkToItemClass.length == 0) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but does not have any fk-pointing-to-element-class configured");
                fkError = true;
            }
            if ((fkToThisClass = this.getFksToThisClass(cld)) == null || fkToThisClass.length == 0) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but does not have any fk-pointing-to-this-class configured");
                fkError = true;
            }
            if (fkError) {
                return null;
            }
            Vector fks = cld.getForeignKeyFields();
            if (fks != null || !fks.isEmpty()) {
                LOG.warn(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a collection descriptor for " + fieldName + " for a M:N relationship but has the inverse-foreignkey configured as opposed to " + "fk-pointing-to-this-class and fk-pointing-to-element-class");
            }
            if (StringUtils.isBlank((String)(itemClassName = cld.getItemClassName()))) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has a reference descriptor for " + fieldName + " but does not class name attribute");
            } else {
                String shortClassName = ClassUtils.getShortClassName((String)itemClassName);
                String packageName = ClassUtils.getPackageName((String)itemClassName);
                pairs.add(new MemberValuePair("targetEntity", (Expression)new NameExpr(shortClassName + ".class")));
                additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(packageName), shortClassName), false, false));
            }
            boolean proxy = cld.isLazy();
            if (proxy) {
                pairs.add(new MemberValuePair("fetch", (Expression)new NameExpr("FetchType.LAZY")));
                additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "FetchType"), false, false));
            }
            if (refresh = cld.isRefresh()) {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has refresh set to " + refresh + ", unsupported conversion to @OneToOne attributes");
            }
            ArrayList<NameExpr> cascadeTypes = new ArrayList<NameExpr>();
            boolean autoRetrieve = cld.getCascadeRetrieve();
            if (autoRetrieve) {
                cascadeTypes.add(new NameExpr("CascadeType.REFRESH"));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-retrieve set to " + autoRetrieve + ", unsupported conversion to CascadeType");
            }
            int autoDelete = cld.getCascadingDelete();
            if (autoDelete == 17) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to none, unsupported conversion to CascadeType");
                }
            } else if (autoDelete == 19) {
                LOG.warn(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to link, unsupported conversion to CascadeType");
            } else if (autoDelete == 23) {
                cascadeTypes.add(new NameExpr("CascadeType.REMOVE"));
            } else {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-delete set to an invalid value");
            }
            if ((autoUpdate = cld.getCascadingStore()) == 17) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to none, unsupported conversion to CascadeType");
                }
            } else if (autoUpdate == 19) {
                LOG.warn(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to link, unsupported conversion to CascadeType");
            } else if (autoUpdate == 23) {
                cascadeTypes.add(new NameExpr("CascadeType.PERSIST"));
            } else {
                LOG.error(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " field has auto-update set to an invalid value");
            }
            if (!cascadeTypes.isEmpty()) {
                pairs.add(new MemberValuePair("cascade", (Expression)new ArrayInitializerExpr(cascadeTypes)));
                additionalImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), "CascadeType"), false, false));
            }
            if (this.isBidirectional(mappedClass, itemClassName)) {
                LOG.info(ResolverUtil.logMsgForField(enclosingClass, fieldName, mappedClass) + " bi-directional ManyToMany relationship detected");
                BidirectionalOwnerRegistry registry = BidirectionalOwnerRegistry.getInstance();
                if (registry.isOwnerThisClassManyToMany(mappedClass, itemClassName)) {
                    nodeData = new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
                } else if (registry.isOwnerItemClassManyToMany(mappedClass, itemClassName)) {
                    nodeData = new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), Collections.singletonList(new MemberValuePair("mappedBy", (Expression)new StringLiteralExpr(this.getMappedBy(mappedClass, itemClassName))))), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
                } else {
                    registry.assignThisClassAsOwnerManyToMany(mappedClass, itemClassName);
                    nodeData = new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
                }
            } else {
                nodeData = new NodeData((AnnotationExpr)new NormalAnnotationExpr(new NameExpr(SIMPLE_NAME), pairs), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), additionalImports);
            }
            return nodeData;
        }
        return null;
    }

    private String[] getFksToItemClass(CollectionDescriptor cld) {
        try {
            return cld.getFksToItemClass();
        }
        catch (NullPointerException e) {
            return new String[0];
        }
    }

    private String[] getFksToThisClass(CollectionDescriptor cld) {
        try {
            return cld.getFksToItemClass();
        }
        catch (NullPointerException e) {
            return new String[0];
        }
    }

    private boolean isBidirectional(String thisClass, String itemClass) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(itemClass, this.descriptorRepositories);
        Vector clds = cd.getCollectionDescriptors();
        if (clds != null) {
            for (CollectionDescriptor cld : clds) {
                if (!cld.getItemClassName().equals(thisClass)) continue;
                return true;
            }
        }
        return false;
    }

    private String getMappedBy(String thisClass, String itemClass) {
        ClassDescriptor cd = OjbUtil.findClassDescriptor(itemClass, this.descriptorRepositories);
        Vector clds = cd.getCollectionDescriptors();
        if (clds != null) {
            for (CollectionDescriptor cld : clds) {
                if (!cld.getItemClassName().equals(thisClass)) continue;
                return cld.getAttributeName();
            }
        }
        return null;
    }
}

